program mkversion;

uses NLib, NSys, NStr, NStdIO;

var
  version, releasedate, copyright, filever: string;
begin
  try
    StdIn.ReadLine(version);
    StdIn.ReadLine(copyright);
    version := Strip(version);
    copyright := Strip(copyright);

    if (Length(Argv) > 1) and (Argv[1] = '-h') then
    begin
      filever := Replace(version, '.', ',');
      Print('#define PRODUCTVER ' + filever);
      Print('#define PRODUCTVERSTR "' + version + '"');
      Print('#define FILEVER ' + filever);
      Print('#define FILEVERSTR "' + version + '"');
      Print('#define COPYRIGHT "'+ copyright + '\0"');
    end
    else begin
      with LocalTime(Time) do
        releasedate := Format('{0}{1:02}{2:02}', [Year, Mon, MDay]);
      Print('unit Version;');
      Print('interface');
      Print('const');
      Print('  Version_ = ''' + version + ''';');
      Print('  ReleaseDate = ''' + releasedate + ''';');
      Print('  Copyright = ''' + copyright + ''';');
      Print('implementation');
      Print('end.');
    end;
  except
    on E: EIOError do SysFatal(E);
  end;
end.
