program mkdefault;

uses NSys, NLib, NStdIO, NConf;

procedure Output(const F: TFile);
const
  suffix = '-default';
var
  name, line: string;
begin
  name := BaseName(F.Name);
  if Copy(name, Length(name)-Length(suffix)+1, 8) <> suffix then
    Exit;

  name := Copy(name, 1, Length(name)-Length(suffix));
  Print(name + '=');
  while TConf.ReadLine(F, line) do
  begin
    if line[Length(line)] = #10 then
    begin
      SetLength(line, Length(line)-1);
      if Line[Length(line)] = #13 then
        SetLength(line, Length(line)-1);
    end;
    Print(''''+line+'''#10+');
  end;
  Print(''''';');
end;

var
  f: TFile;
  i: Integer;
begin
  try
    Print('// generated by mkdefault');
    Print('unit Default;');
    Print('interface');
    Print('const');
    for i := 1 to High(Argv) do
    begin
      f := TFile.Open(Argv[i]);
      try
        Output(f); 
      finally
        f.Free;
      end;
    end;
    Print('implementation');
    Print('end.');
  except
    SysFatal(ExceptObject);
  end;
end.
