unit NStr;

interface

function Find(const S, Sub: string; Start: Integer=1): Integer;
function Format(const S: string; const Args: array of const): string;
function Join(const S: string; Words: array of string): string;
function Replace(const S, Old, New: string): string;
function Reversed(const S: string): string;
function Strip(const S: string): string;

implementation

uses NLib, NSys;

function Find(const S, Sub: string; Start: Integer=1): Integer;
var
  i, j, endi, sublen: Integer;
  m: TMChar;
begin
  Result := 0;
  sublen := Length(Sub);
  if sublen = 0 then
    Exit;
  endi := Length(S) - sublen + 1;
  if endi < Start then
    Exit;
  i := Start;
  repeat
    if S[i] = Sub[1] then
    begin
      j := 1;
      while (j < sublen) and (S[i+j] = Sub[1+j]) do 
        Inc(j);
      if j = sublen then
      begin
        Result := i;
        Exit;
      end;
    end;
  until not EachChar(S, i, m) or (i > endi);
end;

function Format(const S: string; const Args: array of const): string;
  function ToStr(const X: TVarRec; Typc: Char = 'd'): string;
  begin
    with X do
      case VType of
        vtAnsiString: Result := string(VAnsiString);
        vtChar: Result := VChar;
        vtInteger:
          if Typc = 'x' then
            Result := IHex(VInteger)
          else
            Result := IStr(VInteger);
        vtInt64: Result := I64Str(VInt64^);
        vtString: Result := VString^;
      end;
  end;
type
  TState = (sIdx, sLit, sWid, sWidx, sTerm);
var
  i: Integer;
  state: TState;
  t, widstr, idxstr, padstr, widxstr: string;
  c, padc, typc, alignc: Char;
begin
  i := 0;
  state := sLit;
  typc := 'd';
  widstr := '';
  idxstr := '';
  alignc := '<';
  Result := '';
  while i < Length(S) do
  begin
    Inc(i);
    c := S[i];
    case state of
      sLit:
        case c of
          '{':
            if S[i+1] = '{' then
            begin
              Result := Result + c;
              Inc(i);
            end else
              state := sIdx;
          '}':
            if S[i+1] = '}' then
            begin
              Result := Result + c;
              Inc(i);
            end;
        else
          Result := Result + c;
        end;
      sIdx:
        case c of
          '}': state := sTerm;
          ':': state := sWid;
          '0'..'9': idxstr := idxstr + c;
        end;
      sWid:
        case c of
          '{': state := sWidx;
          '}': state := sTerm;
          '0'..'9': widstr := widstr + c;
          '<', '>': alignc := c;
          'd', 'x': typc := c;
        end;
      sWidx:
        case c of
          '}': 
            begin
              widstr := widstr + ToStr(args[SInt(widxstr)]);
              widxstr := '';
              state := sWid;
            end;
          '0'..'9': widxstr := widxstr + c;
        end;
    end;
    if state = sTerm then
    begin
      t := ToStr(args[SInt(idxstr)], typc);
      if (Length(widstr) > 0) and (widstr[1] = '0') then
      begin
        alignc := '>';
        padc := '0'
      end else
        padc := ' ';
      padstr := StringOfChar(padc, SInt(widstr)-Length(t));
      if alignc = '<' then
        Result := Result + t + padstr
      else
        Result := Result + padstr + t;
      idxstr := '';
      widstr := '';
      typc := 'd';
      alignc := '<';
      state := sLit;
    end;
  end;
end;

function Join(const S: string; Words: array of string): string;
var
  i, j, len: Integer;
begin
  len := 0;
  for i := 0 to High(Words) do
    Inc(len, Length(Words[i])); 
  Inc(len, Length(S)*High(Words));
  SetString(Result, nil, len);
  j := 1;
  for i := 0 to High(Words) do
  begin
    Move(Words[i][1], Result[j], Length(Words[i]));
    Inc(j, Length(Words[i]));
    if i = High(Words) then
      Break;
    Move(S[1], Result[j], Length(S));
    Inc(j, Length(S));
  end;
end;

function Replace(const S, Old, New: string): string;
var
  i, oldlen, len, start: Integer;
begin
  Result := '';
  len := Length(S);
  oldlen := Length(Old);
  start := 1;
  while True do
  begin
    i := Find(S, Old, start);
    if i = 0 then
    begin
      Result := Result + Copy(S, start, len-start+1);
      Break;
    end
    else begin
      Result := Result + Copy(S, start, i-start) + New;   
      start := i + oldlen;
    end;
  end;
end;

function Reversed(const S: string): string;
var
  i, j, len: Integer;
  m: TMChar;
begin
  len := Length(S);
  SetString(Result, nil, len);
  i := 1;
  j := i;
  while EachChar(S, i, m) do
  begin
    Move(m, Result[len - i + 2], i - j);
    j := i;
  end;
end;

function Strip(const S: string): string;
var
  i, start, end_: Integer;
begin
  start := 0;
  end_ := Length(S);
  for i := 1 to Length(S) do
    if not (S[i] in [#9, #10, #13, ' ']) then
      if start = 0 then
        start := i
      else
        end_ := i;
  if start = 0 then
    Result := ''
  else
    Result := Copy(S, start, end_ - start + 1);
end;

end.
