unit NKeyMap;

interface

uses Windows;

type
  TKeyState = set of (ksAlt, ksCtrl, ksShift, ksWin);

procedure StrToVkey(const S: string; var State: TKeyState; var Vkey: Word);
function VkeyToKeyName(const State: TKeyState; Vkey: Word): string;
function StrToKeyName(const S: string): string;

implementation

type
  TSpKey = record
    Name: string;
    Caption: string;
    Id: Integer;
  end;

const
  SpKeys: array[0..41] of TSpKey = (
    (Name: 'bs';    Caption: 'BS';    Id: VK_BACK),
    (Name: 'tab';   Caption: 'Tab';   Id: VK_TAB),
    (Name: 'enter'; Caption: 'Enter'; Id: VK_RETURN),
    (Name: 'esc';   Caption: 'Esc';   Id: VK_ESCAPE),
    (Name: 'space'; Caption: 'Space'; Id: VK_SPACE),
    (Name: 'pgup';  Caption: 'PgUp';  Id: VK_PRIOR),
    (Name: 'pgdn';  Caption: 'PgDn';  Id: VK_NEXT),
    (Name: 'end';   Caption: 'End';   Id: VK_END),
    (Name: 'home';  Caption: 'Home';  Id: VK_HOME),
    (Name: 'left';  Caption: 'Left';  Id: VK_LEFT),
    (Name: 'up';    Caption: 'Up';    Id: VK_UP),
    (Name: 'right'; Caption: 'Right'; Id: VK_RIGHT),
    (Name: 'down';  Caption: 'Down';  Id: VK_DOWN),
    (Name: 'ins';   Caption: 'Ins';   Id: VK_INSERT),
    (Name: 'del';   Caption: 'Del';   Id: VK_DELETE),
    (Name: 'num0';  Caption: 'Num0';  Id: VK_NUMPAD0),
    (Name: 'num1';  Caption: 'Num1';  Id: VK_NUMPAD1),
    (Name: 'num2';  Caption: 'Num2';  Id: VK_NUMPAD2),
    (Name: 'num3';  Caption: 'Num3';  Id: VK_NUMPAD3),
    (Name: 'num4';  Caption: 'Num4';  Id: VK_NUMPAD4),
    (Name: 'num5';  Caption: 'Num5';  Id: VK_NUMPAD5),
    (Name: 'num6';  Caption: 'Num6';  Id: VK_NUMPAD6),
    (Name: 'num7';  Caption: 'Num7';  Id: VK_NUMPAD7),
    (Name: 'num8';  Caption: 'Num8';  Id: VK_NUMPAD8),
    (Name: 'num9';  Caption: 'Num9';  Id: VK_NUMPAD9),
    (Name: 'num*';  Caption: 'Num*';  Id: VK_MULTIPLY),
    (Name: 'num+';  Caption: 'Num+';  Id: VK_ADD),
    (Name: 'num-';  Caption: 'Num-';  Id: VK_SUBTRACT),
    (Name: 'num.';  Caption: 'Num.';  Id: VK_DECIMAL),
    (Name: 'num/';  Caption: 'Num/';  Id: VK_DIVIDE),
    (Name: 'f1';    Caption: 'F1';    Id: VK_F1),
    (Name: 'f2';    Caption: 'F2';    Id: VK_F2),
    (Name: 'f3';    Caption: 'F3';    Id: VK_F3),
    (Name: 'f4';    Caption: 'F4';    Id: VK_F4),
    (Name: 'f5';    Caption: 'F5';    Id: VK_F5),
    (Name: 'f6';    Caption: 'F6';    Id: VK_F6),
    (Name: 'f7';    Caption: 'F7';    Id: VK_F7),
    (Name: 'f8';    Caption: 'F8';    Id: VK_F8),
    (Name: 'f9';    Caption: 'F9';    Id: VK_F9),
    (Name: 'f10';   Caption: 'F10';   Id: VK_F10),
    (Name: 'f11';   Caption: 'F11';   Id: VK_F11),
    (Name: 'f12';   Caption: 'F12';   Id: VK_F12)
  );

procedure StrToVkey(const S: string; var State: TKeyState; var Vkey: Word);
var
  i: Integer;
  m, k: string;
begin
  m := '';
  for i := 1 to Length(S) do
    if (S[i] = '-') and (i > 1)  then
    begin
      m := Copy(S, 1, i-1);
      k := Copy(S, i+1, Length(S)-i);
      Break;
    end;
  if (m = '') or (k = '') then
    k := S;

  State := [];
  for i := 1 to Length(m) do
    case m[i] of
      'a', 'A': Include(State, ksAlt);
      'c', 'C': Include(State, ksCtrl);
      's', 'S': Include(State, ksShift);
      'w', 'W': Include(State, ksWin);
    end;

  for i := 0 to High(SpKeys) do
    if k = SpKeys[i].Name then
    begin
      Vkey := SpKeys[i].Id;
      Exit;
    end;

  Vkey := VkKeyScan(k[1]) and $FF;
end;

function VkeyToKeyName(const State: TKeyState; Vkey: Word): string;
var
  i: Integer;
begin
  Result := '';
  if ksCtrl  in State then Result := Result + 'Ctrl+';
  if ksShift in State then Result := Result + 'Shift+';
  if ksAlt   in State then Result := Result + 'Alt+';

  for i := 0 to High(SpKeys) do
    if Vkey = SpKeys[i].Id then
    begin
      Result := Result + SpKeys[i].Caption;
      Exit;
    end;

  Result := Result + Chr(MapVirtualKey(Vkey, 2) and $FF);
end;

function StrToKeyName(const S: string): string;
var
  ks: TKeyState;
  vkey: Word;
begin
  StrToVkey(S, ks, vkey);
  Result := VkeyToKeyName(ks, vkey);
end;

end.
