unit NConf;

interface

uses NTypes, NLib, NSys, NDict;

type
  TConf = class(TStrArrayDict)
  public
    Parser: function (const S: string): TStringArray;
    class function ReadLine(const F: TStream; var Line: string): Boolean;
    function GetBool(const Key: string; Index: Integer=0;
        Default: Boolean=False): Boolean;
    function GetInt(const Key: string; Index: Integer=0; Default: Integer=0):
        Integer;
    function GetStr(const Key: string; Index: Integer=0; Default: string=''):
        string;
    procedure Read(const F: TStream); overload;
    procedure Read(const S: string); overload;
    procedure Write(const F: TStream);
    procedure LoadFromFile(const Path: string);
    procedure SaveToFile(const Path: string);
  end;

implementation

class function TConf.ReadLine(const F: TStream; var Line: string): Boolean;
begin
  while True do
  begin
    Result := F.ReadLine(Line);
    if Result then
    begin
      if (line = #13#10) or (Line[1] in ['#', #10]) then
        Continue;
      if Line[Length(Line)] = #10 then
      begin
        SetLength(Line, Length(Line)-1);
        if Line[Length(Line)] = #13 then
          SetLength(Line, Length(Line)-1);
      end;
    end;
    Exit;
  end;
end;

function TConf.GetBool(const Key: string; Index: Integer; Default: Boolean):
    Boolean;
var
  args: TStringArray;
begin
  args := Items[Key];
  if (args = nil) or (High(args) < Index) then
    Result := Default
  else
    Result := (args[Index] = 'on') or (Sint(args[Index]) <> 0);
end;

function TConf.GetInt(const Key: string; Index: Integer; Default: Integer):
    Integer;
var
  args: TStringArray;
begin
  args := Items[Key];
  if (args = nil) or (High(args) < Index) then
    Result := Default
  else
    Result := SInt(args[Index]);
end;

function TConf.GetStr(const Key: string; Index: Integer; Default: string):
    string;
var
  args: TStringArray;
begin
  args := Items[Key];
  if (args = nil) or (High(args) < Index) then
    Result := Default
  else
    Result := args[Index];
end;

procedure TConf.LoadFromFile(const Path: string);
var
  f: TFile;
begin
  try
    f := TFile.Open(Path);
    try
      Read(f);
    finally
      f.Free;
    end;
  except
    on E: EIOError do ;
  end;
end;

procedure TConf.SaveToFile(const Path: string);
var
  f: TFile;
begin
  f := TFile.Create(Path);
  try
    Write(f);
  finally
    f.Free;
  end;
end;

procedure TConf.Read(const F: TStream);
var
  line: string;
  args: TStringArray;
begin
  if not Assigned(Parser) then
    Parser := SplitCommandLine;
  args := nil;
  while F.ReadLine(line) do
  begin
    if (line = #13#10) or (Line[1] in ['#', #10]) then
      Continue;
    args := Parser(line);
    SliceArray(args, 1);
    Items[args[0]] := SliceArray(args, 1);
  end;
end;

procedure TConf.Read(const S: string);
var
  bs: TBytesStream;
begin
  bs := TBytesStream.Create(S);
  try
    Read(bs);
  finally
    bs.Free;
  end;
end;

procedure TConf.Write(const F: TStream);
var
  i: Integer;
  s, key: string;
  args: TStringArray;
begin
  args := nil; // suppress warning
  while EachKeys(key) do
  begin
    args := Items[key];
    s := key;
    for i := 0 to High(args) do
      s := s + ' ' + args[i]; // TODO: support quote
    Print(F, s);
  end;
end;

end.
