unit NBStream;

interface

uses NLib;

type
  TBOutStream = class(TStream)
  private
    Buffer: PChar;
    BufferRemain: Integer;
    BufferSize: Integer;
    Stream: TStream;
  public
    constructor Create(const Stream: TStream; BufferSize: Integer=8192);
    destructor Destroy; override;
    function Read(var Buf; NBytes: Cardinal): Cardinal; override;
    function Write(const Buf; NBytes: Cardinal): Cardinal; override;
    function Seek(Offset: Integer; Whence: TSeekWhence=swSet): Cardinal;
        override;
    function Seekable: Boolean; override;
    function Size: Cardinal; override;
    procedure Flush;
  end;

implementation  

constructor TBOutStream.Create(const Stream: TStream;
    BufferSize: Integer=8192);
begin
  Self.Stream := Stream;
  Self.BufferSize := BufferSize;
  GetMem(Buffer, Self.BufferSize);
  BufferRemain := Self.BufferSize;
end;

destructor TBOutStream.Destroy;
begin
  Flush;
  FreeMem(Buffer);
end;

function TBOutStream.Read(var Buf; NBytes: Cardinal): Cardinal;
begin
  Result := 0
end;

function TBOutStream.Write(const Buf; NBytes: Cardinal): Cardinal;
var
  wbytes, remain: Cardinal;
begin
  remain := NBytes;
  while remain > 0 do
  begin
    if remain > Cardinal(BufferSize) then
      wbytes := BufferSize
    else
      wbytes := remain;
    if Cardinal(BufferRemain) < wbytes then
      Flush;
    Move(PChar(@Buf)[NBytes-remain], Buffer[BufferSize-BufferRemain], wbytes);
    Dec(BufferRemain, wbytes);
    Dec(remain, wbytes);
  end;
  Result := NBytes;
end;

function TBOutStream.Seek(Offset: Integer; Whence: TSeekWhence=swSet):
    Cardinal;
begin
  Flush;
  Result := Stream.Seek(Offset, Whence);
end;

function TBOutStream.Seekable: Boolean;
begin
  Result := Stream.Seekable;
end;

function TBOutStream.Size: Cardinal;
begin
  Result := Stream.Size;
end;

procedure TBOutStream.Flush;
begin
  if BufferRemain = BufferSize then
    Exit;
  Stream.Write(Buffer^, BufferSize - BufferRemain);
  BufferRemain := BufferSize; 
end;

end.
