unit NArgParser;

interface

uses NTypes, NLib;

type
  TArgParser = object
  private
    ArgInd: Integer;
    FArgs: TStringArray;
    Opt: PChar;
  public
    function Args: TStringArray;
    function GetArg: string;
    function GetOpt(var Opt_: Char): Boolean;
  end;

function ArgParser(): TArgParser; overload;
function ArgParser(const Args: array of string): TArgParser; overload;

implementation

uses NSys;

function ArgParser(): TArgParser;
begin
  Result.FArgs := Argv;
  Result.ArgInd := 1;
end;

function ArgParser(const Args: array of string): TArgParser;
var
  i: Integer;
begin
  SetLength(Result.FArgs, Length(Args));
  for i := 0 to High(Result.FArgs) do 
    Result.FArgs[i] := Args[i];
end;

function TArgParser.Args: TStringArray;
begin
  Result := SliceArray(FArgs, ArgInd);
end;

function TArgParser.GetOpt(var Opt_: Char): Boolean;
begin
  if Opt <> nil then
    Inc(Opt);

  if (Opt = nil) or (Opt^ = #0) then
  begin
    Result := False;
    if ArgInd = Length(FArgs) then
      Exit;
    Opt := PChar(FArgs[ArgInd]);
    if Opt = '--' then
    begin
      Inc(ArgInd);
      Exit;
    end;
    if Opt^ = '-' then
      Inc(Opt)
    else
      Exit;
    Inc(ArgInd);
  end;
  Opt_ := Opt^;
  Result := Opt_ <> #0;
end;

function TArgParser.GetArg: string;
begin
  Inc(Opt);
  if Opt^ = #0 then
  begin
    if ArgInd < Length(FArgs) then
    begin
      Result := FArgs[ArgInd];
      Inc(ArgInd); 
    end else
      Result := '';
  end else
    Result := Opt;
  Opt := nil;
end;

end.
