program NkVp;

uses NTypes, NLib, NSys, NArgParser, NForm, NCommand, NConf, Default, MainForm;

{$R *.RES}

var
  buf: string = '';
  i: Integer;
  opt: Char;
  eflag: Boolean = False;
  fflag: Boolean = False;
  keymap: TConf;
  keys: TStringArray = nil;
begin
  App.Name := 'NkVp';

  with ArgParser do
  begin
    while GetOpt(opt) do
      case opt of
        'e': eflag := True;
        'f': fflag := True;
      else
        App.Error('usage: nkvp [-ef] [file ...]');
        Exit;
      end;
    Argv := Args;
  end;

  if Length(Argv) > 0 then
    try
      SendToRemoteForm(TNkVpMainForm, JoinCommandLine(Argv));
      Exit;
    except
      on E: EOSError do ;
    end;

  ProfDir := GetEnv('NKTOOLSPROF');
  if ProfDir = '' then
    ProfDir := DirName(ProgPath)
  else
    ProfDir := JoinPath([ProfDir, 'nkvp']);

  Config := TConf.Create;
  Config.LoadFromFile(JoinPath([ProfDir, 'position']));
  Config.Read(Default.Config); // override 'w' and 'h'
  Config.LoadFromFile(JoinPath([ProfDir, 'config']));

  keymap := TConf.Create;
  keymap.Read(Default.KeyMap);
  keymap.LoadFromFile(JoinPath([ProfDir, 'keymap']));

  App.MainForm := TNkVpMainForm.Create;
  Command := TCommand.Create(App.MainForm);
  Command.BindKeys(keymap);
  keymap.Free;
  App.Accel := Command.AccelHandle;
  with App.MainForm as TNkVpMainForm do
  begin
    ExitAtEnd := eflag;
    for i := 0 to High(Argv) do
      Playlist.Add(Argv[i]);
    Show;
    LoadFromPlaylist(0, not FitMovie);
    if Player.Loaded and fflag then
      cmFullScreen;
  end;
  ExitCode := App.Run;

  Command.Free;
  App.MainForm.Free;
  Config.Free;
end.
