unit InfoDialog;

interface

uses NLib, NForm, NCanvas, NMInfo, Player;

type
  TInfoDialog = class(TDialog)
    Icon: TIcon;
    Player: TPlayer;
    MInfo: PMInfo;
    ATime, MTime: Int64;
    Size: Cardinal;
    destructor Destroy; override;
    procedure Init(var DefaultFocus: TWindow); override;
    procedure UpdateInfo;
  end;

implementation

uses NSys, NStr;

{$I dialogid.inc}

function BytesFormat(Value: Int64): string;
var
  s: string;
begin
  Result := UnitFormat(Value);
  s := Copy(Result, 1, Length(Result)-1);
  case Result[Length(Result)] of
    'G': Result := s + ' GB';
    'M': Result := s + ' MB';
    'K': Result := s + ' KB';
  else
    Result := Result + ' bytes';
  end;
end;

destructor TInfoDialog.Destroy;
begin
  if Assigned(Icon) then
    Icon.Free;
  inherited;
end;

procedure TInfoDialog.Init(var DefaultFocus: TWindow);
begin
  UpdateInfo;
end;

procedure TInfoDialog.UpdateInfo;
var
  t: TTime;
  hasvideo, isurl: Boolean;
begin
  isurl :=(Copy(Player.Path, 1, 7) = 'http://') or
      (Copy(Player.Path, 1, 8) = 'https://');
  if not Assigned(Icon) then
    Icon := TIcon.Create;
  Icon.LoadFileIcon(Player.Path);
  SetIcon(IDC_ICON, Icon);

  Items[IDC_FILENAME].SetText(BaseName(Player.Path));
  if isurl then
    Items[IDC_LOCATION].SetText(Player.Path)
  else
    Items[IDC_LOCATION].SetText(DirName(AbsPath(Player.Path)));
  Items[IDC_LENGTH].SetText(Format('{0:02}:{1:02}:{2:02}',
      [Player.Len div 3600000, Player.Len mod 3600000 div 60000,
      Player.Len mod 60000 div 1000]));
  if Player.OpenedDvd then
    Items[IDC_FORMAT].SetText('<DVD>')
  else
    Items[IDC_FORMAT].SetText(MInfo.Container);

  hasvideo := Player.HasVideo or (MInfo.VideoWidth > 0);
  Items[IDC_SIZELABEL].Enable(hasvideo);
  Items[IDC_FPSLABEL].Enable(hasvideo);
  Items[IDC_FILEASPECTLABEL].Enable(hasvideo);
  Items[IDC_VIDEOCODECLABEL].Enable(hasvideo);
  if hasvideo then
  begin
    Items[IDC_SIZE].SetText(Format('{0}x{1}  (output: {2}x{3})',
        [MInfo.VideoWidth, MInfo.VideoHeight,
        Player.VideoWidth, Player.VideoHeight]));
    Items[IDC_FPS].SetText(Format('{0} fps  (output: {1} fps)',
        [FStr(MInfo.VideoFrameRate, 3), FStr(Player.VideoFrameRate, 3)]));
    Items[IDC_FILEASPECT].SetText(FStr(Player.VideoAspect, 4));
    Items[IDC_VIDEOCODEC].SetText(MInfo.VideoCodec);
  end else
  begin
    Items[IDC_SIZE].SetText('');
    Items[IDC_FPS].SetText('');
    Items[IDC_FILEASPECT].SetText('');
    Items[IDC_VIDEOCODEC].SetText('');
  end;

  if MInfo.AudioChannels = 0 then
    Items[IDC_AUDIOCHANNELS].SetText('')
  else
    Items[IDC_AUDIOCHANNELS].SetText(IStr(MInfo.AudioChannels));
  if MInfo.AudioSampleRate = 0 then
    Items[IDC_AUDIOSAMPLERATE].SetText('')
  else
    Items[IDC_AUDIOSAMPLERATE].SetText(
        Format('{0} Hz', [MInfo.AudioSampleRate]));
  if MInfo.AudioBitRate = 0 then
    Items[IDC_AUDIOBITRATE].SetText('')
  else
    Items[IDC_AUDIOBITRATE].SetText(Format('{0} bps', [MInfo.AudioBitRate]));
  Items[IDC_AUDIOCODEC].SetText(MInfo.AudioCodec);

  Items[IDC_FILESIZE].SetText(
      Format('{0} ({1} bytes)', [BytesFormat(Size), NumFormat(Size)]));
  t := LocalTime(MTime);
  Items[IDC_MODIFIED].SetText(
      Format('{0:04}-{1:02}-{2:02} {3:02}:{4:02}:{5:02}',
        [t.Year, t.Mon, t.MDay, t.Hour, t.Min, t.Sec]));
  t := LocalTime(ATime);
  Items[IDC_ACCESSED].SetText(
      Format('{0:04}-{1:02}-{2:02} {3:02}:{4:02}:{5:02}',
        [t.Year, t.Mon, t.MDay, t.Hour, t.Min, t.Sec]));
end;

end.
