unit DShowSub;

{$Z4}

interface

uses Windows, ActiveX;

type
  TCHAR = PChar;
  DWORD_PTR = Longint;
  LONG_PTR = Longint;
  ULONGLONG = Int64; // XXX Delphi 6 not supported unsigned 64bit integer


const
  MAX_ERROR_TEXT_LEN = 160;

function AMGetErrorText(hr: HRESULT; pbuffer: TCHAR; MaxLen: DWORD): DWORD; stdcall; external 'quartz.dll' name 'AMGetErrorTextA';


const
  OATRUE = -1;
  OAFALSE = 0;

  VFW_S_DUPLICATE_NAME = $0004022D;
  VFW_S_PARTIAL_RENDER = $00040242;
  VFW_S_VIDEO_NOT_RENDERED = $00040257;
  VFW_S_AUDIO_NOT_RENDERED = $00040258;
  VFW_S_STATE_INTERMEDIATE = $00040237;

  CLSID_NullRenderer: TGUID = '{C1F400A4-3F08-11D3-9F0B-006008039E37}';
  CLSID_SampleGrabber: TGUID = '{C1F400A0-3F08-11D3-9F0B-006008039E37}';
  CLSID_VideoMixingRenderer9: TGUID = '{51B4ABF3-748F-4E3B-A276-C828330E926A}';
  CLSID_FilterGraph: TGUID = '{E436EBB3-524F-11CE-9F53-0020AF0BA770}';
  CLSID_DVDNavigator: TGUID = '{9B8C4620-2C1A-11D0-8493-00A02438AD48}';
  CLSID_Line21Decoder: TGUID = '{6E8D4A20-310C-11D0-B79A-00AA003767A7}';
  CLSID_Line21Decoder2: TGUID = '{E4206432-01A1-4BEE-B3E1-3702C8EDC574}';

  IID_IBaseFilter: TGUID = '{56A86895-0AD4-11CE-B03A-0020AF0BA770}';
  IID_IGraphBuilder: TGUID = '{56A868A9-0AD4-11CE-B03A-0020AF0BA770}';
  IID_ISpecifyPropertyPages: TGUID = '{B196B28B-BAB4-101A-B69C-00AA00341D07}';
  IID_IVMRAspectRatioControl9: TGUID = '{00D96C29-BBDE-4EFC-9901-BB5036392146}';
  IID_IVMRFilterConfig9: TGUID = '{5A804648-4F66-4867-9C43-4F5C822CF1B8}';
  IID_IAMLine21Decoder: TGUID = '{6E8D4A21-310C-11D0-B79A-00AA003767A7}';
  
  MEDIATYPE_Video: TGUID = '{73646976-0000-0010-8000-00AA00389B71}';
  MEDIASUBTYPE_RGB24: TGUID = '{E436EB7D-524F-11CE-9F53-0020AF0BA770}';

  MAX_PIN_NAME = 128;
  MAX_FILTER_NAME = 128;

type
  OAHWND = LONG_PTR;
  OAEVENT = LONG_PTR;

  REFERENCE_TIME = LONGLONG;

  TVideoInfoHeader = record
    rcSource: TRect;
    rcTarget: TRect;
    dwBitRate: DWORD;
    dwBitErrorRate: DWORD;
    AvgTimePerFrame: REFERENCE_TIME;
    bmiHeader: TBitmapInfoHeader;
  end;
  
  PAM_MEDIA_TYPE = ^AM_MEDIA_TYPE;
  AM_MEDIA_TYPE = record
    majortype: TGUID;
    subtype: TGUID;
    bFixedSizeSamples: BOOL;
    bTemporalCompression: BOOL;
    lSampleSize: ULONG;
    formattype: TGUID;
    pUnk: IUnknown;
    cbFormat: ULONG;
    pbFormat: Pointer;
  end;
  
  PIN_DIRECTION = (
    PINDIR_INPUT,
    PINDIR_OUTPUT
  );
  
  TRefTime = Double;

  HEVENT = Longint;
  HSEMAPHORE = Longint;

  IBaseFilter = interface;

  PIN_INFO = record
    pFilter: IBaseFilter;
    dir: PIN_DIRECTION;
    achName: array[0..MAX_PIN_NAME-1] of WCHAR;
  end;

  IEnumMediaTypes = interface;

  IPin = interface(IUnknown)
    ['{56A86891-0AD4-11CE-B03A-0020AF0BA770}']
    function Connect(ReceivePin: IPin; pmt: PAM_MEDIA_TYPE): HRESULT; stdcall;
    function ReceiveConnection(Connector: IPin; var mt: AM_MEDIA_TYPE): HRESULT; stdcall;
    function Disconnect: HRESULT; stdcall;
    function ConnectedTo(out Pin: IPin): HRESULT; stdcall;
    function ConnectionMediaType(out mt: AM_MEDIA_TYPE): HRESULT; stdcall;
    function QueryPinInfo(out Info: PIN_INFO): HRESULT; stdcall;
    function QueryDirection(out PinDir: PIN_DIRECTION): HRESULT; stdcall;
    function QueryId(out Id: LPWSTR): HRESULT; stdcall;
    function QueryAccept(var mt: AM_MEDIA_TYPE): HRESULT; stdcall;
    function EnumMediaTypes(out Enum: IEnumMediaTypes): HRESULT; stdcall;
    function QueryInternalConnections(out aPin: IPin; var nPin: ULONG): HRESULT; stdcall;
    function EndOfStream: HRESULT; stdcall;
    function BeginFlush: HRESULT; stdcall;
    function EndFlush: HRESULT; stdcall;
    function NewSegment(Start, Stop: REFERENCE_TIME; Rate: double): HRESULT; stdcall;
  end;

  IEnumPins = interface(IUnknown)
    ['{56A86892-0AD4-11CE-B03A-0020AF0BA770}']
    function Next(cPins: ULONG; out Pins; out cFetched: ULONG): HRESULT; stdcall;
    function Skip(cPins: ULONG): HRESULT; stdcall;
    function Reset: HRESULT; stdcall;
    function Clone(out Enum: IEnumPins): HRESULT; stdcall;
  end;

  IEnumMediaTypes = interface(IUnknown)
    ['{89C31040-846B-11CE-97D3-00AA0055595A}']
    function Next(cMediaTypes: ULONG; out pMediaTypes: PAM_MEDIA_TYPE; out cFetched: ULONG): HRESULT; stdcall;
    function Skip(cMediaTypes: ULONG): HRESULT; stdcall;
    function Reset: HRESULT; stdcall;
    function Clone(out Enum: IEnumMediaTypes): HRESULT; stdcall;
  end;

  IEnumFilters = interface;

  IFilterGraph = interface(IUnknown)
    ['{56A8689F-0AD4-11CE-B03A-0020AF0BA770}']
    function AddFilter(Filter: IBaseFilter; Name: LPCWSTR): HRESULT; stdcall;
    function RemoveFilter(Filter: IBaseFilter): HRESULT; stdcall;
    function EnumFilters(out Enum: IEnumFilters): HRESULT; stdcall;
    function FindFilterByName(Name: LPCWSTR; out Filter: IBaseFilter): HRESULT; stdcall;
    function ConnectDirect(pinOut, pinIn: IPin; pmt: PAM_MEDIA_TYPE): HRESULT; stdcall;
    function Reconnect(pin: IPin): HRESULT; stdcall;
    function Disconnect(pin: IPin): HRESULT; stdcall;
    function SetDefaultSyncSource: HRESULT; stdcall;
  end;

  IEnumFilters = interface(IUnknown)
    ['{56A86893-0AD4-11CE-B03A-0020AF0BA770}']
    function Next(cFilters: ULONG; out Filter: IBaseFilter; out cFetched: ULONG): HRESULT; stdcall;
    function Skip(cFilters: ULONG): HRESULT; stdcall;
    function Reset: HRESULT; stdcall;
    function Clone(out Enum: IEnumFilters): HRESULT; stdcall;
  end;

  FILTER_STATE = (
    State_Stopped,
    State_Paused,
    State_Running
  );

  IReferenceClock = interface;

  IMediaFilter = interface(IPersist)
    ['{56A86899-0AD4-11CE-B03A-0020AF0BA770}']
    function Stop: HRESULT; stdcall;
    function Pause: HRESULT; stdcall;
    function Run(Start: REFERENCE_TIME): HRESULT; stdcall;
    function GetState(MilliSecsTimeout: DWORD; out State: FILTER_STATE): HRESULT; stdcall;
    function SetSyncSource(Clock: IReferenceClock): HRESULT; stdcall;
    function GetSyncSource(out Clock: IReferenceClock): HRESULT; stdcall;
  end;

  FILTER_INFO = record
    achName: array[0..MAX_FILTER_NAME-1] of WCHAR;
    pGraph: IFilterGraph;
  end;

  IBaseFilter = interface(IMediaFilter)
    ['{56A86895-0AD4-11CE-B03A-0020AF0BA770}']
    function EnumPins(out Enum: IEnumPins): HRESULT; stdcall;
    function FindPin(Id: LPCWSTR; out Pin: IPin): HRESULT; stdcall;
    function QueryFilterInfo(out Info: FILTER_INFO): HRESULT; stdcall;
    function JoinFilterGraph(Graph: IFilterGraph; Name: LPCWSTR): HRESULT; stdcall;
    function QueryVendorInfo(out VendorInfo: LPWSTR): HRESULT; stdcall;
  end;

  IReferenceClock = interface(IUnknown)
    ['{56A86897-0AD4-11CE-B03A-0020AF0BA770}']
    function GetTime(var Time: REFERENCE_TIME): HRESULT; stdcall;
    function AdviseTime(BaseTime, StreamTime: REFERENCE_TIME; Event: HEVENT; out AdviseCookie: DWORD): HRESULT; stdcall;
    function AdvisePeriodic(StartTime, PeriodTime: REFERENCE_TIME; Semaphore: HSEMAPHORE; out AdviseCookie: DWORD): HRESULT; stdcall;
    function Unadvise(AdviseCookie: DWORD): HRESULT; stdcall;
  end;
  
  IGraphBuilder = interface(IFilterGraph)
    ['{56A868A9-0AD4-11CE-B03A-0020AF0BA770}']
    function Connect(pinOut, pinIn: IPin): HRESULT; stdcall;
    function Render(pinOut: IPin): HRESULT; stdcall;
    function RenderFile(File_, PlayList: LPCWSTR): HRESULT; stdcall;
    function AddSourceFilter(FileName, FilterName: LPCWSTR; out Filter: IBaseFilter): HRESULT; stdcall;
    function SetLogFile(hFile: DWORD_PTR): HRESULT; stdcall;
    function Abort: HRESULT; stdcall;
    function ShouldOperationContinue: HRESULT; stdcall;
  end;

  IMediaSample = interface(IUnknown)
    ['{56A8689A-0AD4-11CE-B03A-0020AF0BA770}']
    function GetPointer(out pBuffer: Pointer): HRESULT; stdcall;
    function GetSize: Longint; stdcall;
    function GetTime(out TimeStart, TimeEnd: REFERENCE_TIME): HRESULT; stdcall;
    function SetTime(var TimeStart, TimeEnd: REFERENCE_TIME): HRESULT; stdcall;
    function IsSyncPoint: HRESULT; stdcall;
    function SetSyncPoint(IsSyncPoint: BOOL): HRESULT; stdcall;
    function IsPreroll: HRESULT; stdcall;
    function SetPreroll(IsPreroll: BOOL): HRESULT; stdcall;
    function GetActualDataLength: Longint; stdcall;
    function SetActualDataLength(Len: Longint): HRESULT; stdcall;
    function GetMediaType(var pMediaType: PAM_MEDIA_TYPE): HRESULT; stdcall;
    function SetMediaType(var MediaType: AM_MEDIA_TYPE): HRESULT; stdcall;
    function IsDiscontinuity: HRESULT; stdcall;
    function SetDiscontinuity(IsDiscontinuity: BOOL): HRESULT; stdcall;
    function GetMediaTime(out TimeStart, TimeEnd: REFERENCE_TIME): HRESULT; stdcall;
    function SetMediaTime(var TimeStart, TimeEnd: REFERENCE_TIME): HRESULT; stdcall;
  end;

  IBasicAudio = interface(IDispatch)
    ['{56A868B3-0AD4-11CE-B03A-0020AF0BA770}']
    function put_Volume(Volume: Longint): HRESULT; stdcall;
    function get_Volume(out Volume: Longint): HRESULT; stdcall;
    function put_Balance(Balance: Longint): HRESULT; stdcall;
    function get_Balance(out Balance: Longint): HRESULT; stdcall;
  end;

  IVideoWindow = interface(IDispatch)
    ['{56A868B4-0AD4-11CE-B03A-0020AF0BA770}']
    function put_Caption(Caption: TBSTR): HRESULT; stdcall;
    function get_Caption(out Caption: TBSTR): HRESULT; stdcall;
    function put_WindowStyle(WindowStyle: Longint): HRESULT; stdcall;
    function get_WindowStyle(out WindowStyle: Longint): HRESULT; stdcall;
    function put_WindowStyleEx(WindowStyleEx: Longint): HRESULT; stdcall;
    function get_WindowStyleEx(out WindowStyleEx: Longint): HRESULT; stdcall;
    function put_AutoShow(AutoShow: Longint): HRESULT; stdcall;
    function get_AutoShow(out AutoShow: Longint): HRESULT; stdcall;
    function put_WindowState(WindowState: Longint): HRESULT; stdcall;
    function get_WindowState(out WindowState: Longint): HRESULT; stdcall;
    function put_BackgroundPalette(BackgroundPalette: Longint): HRESULT; stdcall;
    function get_BackgroundPalette(out BackgroundPalette: Longint): HRESULT; stdcall;
    function put_Visible(Visible: Longint): HRESULT; stdcall;
    function get_Visible(out Visible: Longint): HRESULT; stdcall;
    function put_Left(Left: Longint): HRESULT; stdcall;
    function get_Left(out Left: Longint): HRESULT; stdcall;
    function put_Width(Width: Longint): HRESULT; stdcall;
    function get_Width(out Width: Longint): HRESULT; stdcall;
    function put_Top(Top: Longint): HRESULT; stdcall;
    function get_Top(out Top: Longint): HRESULT; stdcall;
    function put_Height(Height: Longint): HRESULT; stdcall;
    function get_Height(out Height: Longint): HRESULT; stdcall;
    function put_Owner(Owner: OAHWND): HRESULT; stdcall;
    function get_Owner(out Owner: OAHWND): HRESULT; stdcall;
    function put_MessageDrain(Drain: OAHWND): HRESULT; stdcall;
    function get_MessageDrain(out Drain: OAHWND): HRESULT; stdcall;
    function get_BorderColor(out Color: Longint): HRESULT; stdcall;
    function put_BorderColor(Color: Longint): HRESULT; stdcall;
    function get_FullScreenMode(out FullScreenMode: LongBool): HRESULT; stdcall;
    function put_FullScreenMode(FullScreenMode: LongBool): HRESULT; stdcall;
    function SetWindowForeground(Focus: Longint): HRESULT; stdcall;
    function NotifyOwnerMessage(hwnd: OAHWND; uMsg: Longint; wParam, lParam: LONG_PTR): HRESULT; stdcall;
    function SetWindowPosition(Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function GetWindowPosition(out Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function GetMinIdealImageSize(out Width, Height: Longint): HRESULT; stdcall;
    function GetMaxIdealImageSize(out Width, Height: Longint): HRESULT; stdcall;
    function GetRestorePosition(out Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function HideCursor(HideCursor: Longint): HRESULT; stdcall;
    function IsCursorHidden(out CursorHidden: Longint): HRESULT; stdcall;
  end;

  IBasicVideo = interface(IDispatch)
    ['{56A868B5-0AD4-11CE-B03A-0020AF0BA770}']
    function get_AvgTimePerFrame(out AvgTimePerFrame: TRefTime): HRESULT; stdcall;
    function get_BitRate(out BitRate: Longint): HRESULT; stdcall;
    function get_BitErrorRate(out BitErrorRate: Longint): HRESULT; stdcall;
    function get_VideoWidth(out VideoWidth: Longint): HRESULT; stdcall;
    function get_VideoHeight(out VideoHeight: Longint): HRESULT; stdcall;
    function put_SourceLeft(SourceLeft: Longint): HRESULT; stdcall;
    function get_SourceLeft(out SourceLeft: Longint): HRESULT; stdcall;
    function put_SourceWidth(SourceWidth: Longint): HRESULT; stdcall;
    function get_SourceWidth(out SourceWidth: Longint): HRESULT; stdcall;
    function put_SourceTop(SourceTop: Longint): HRESULT; stdcall;
    function get_SourceTop(out SourceTop: Longint): HRESULT; stdcall;
    function put_SourceHeight(SourceHeight: Longint): HRESULT; stdcall;
    function get_SourceHeight(out SourceHeight: Longint): HRESULT; stdcall;
    function put_DestinationLeft(DestinationLeft: Longint): HRESULT; stdcall;
    function get_DestinationLeft(out DestinationLeft: Longint): HRESULT; stdcall;
    function put_DestinationWidth(DestinationWidth: Longint): HRESULT; stdcall;
    function get_DestinationWidth(out DestinationWidth: Longint): HRESULT; stdcall;
    function put_DestinationTop(DestinationTop: Longint): HRESULT; stdcall;
    function get_DestinationTop(out DestinationTop: Longint): HRESULT; stdcall;
    function put_DestinationHeight(DestinationHeight: Longint): HRESULT; stdcall;
    function get_DestinationHeight(out DestinationHeight: Longint): HRESULT; stdcall;
    function SetSourcePosition(Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function GetSourcePosition(out Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function SetDefaultSourcePosition: HRESULT; stdcall;
    function SetDestinationPosition(Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function GetDestinationPosition(out Left, Top, Width, Height: Longint): HRESULT; stdcall;
    function SetDefaultDestinationPosition: HRESULT; stdcall;

    function GetVideoSize(out Width, Height: Longint): HRESULT; stdcall;
    function GetVideoPaletteEntries(StartIndex, Entries: Longint; out Retrieved: Longint; out Palette): HRESULT; stdcall;
    function GetCurrentImage(var BufferSize: Longint; out DIBImage): HRESULT; stdcall;
    function IsUsingDefaultSource: HRESULT; stdcall;
    function IsUsingDefaultDestination: HRESULT; stdcall;
  end;

  IBasicVideo2 = interface(IBasicVideo)
    ['{329BB360-F6EA-11D1-9038-00A0C9697298}']
    function GetPreferredAspectRatio(out AspectX, AspectY: Longint): HRESULT; stdcall;
  end;

  IMediaControl = interface(IDispatch)
    ['{56A868B1-0AD4-11CE-B03A-0020AF0BA770}']
    function Run: HRESULT; stdcall;
    function Pause: HRESULT; stdcall;
    function Stop: HRESULT; stdcall;
    function GetState(msTimeout: Longint; out fs: FILTER_STATE): HRESULT; stdcall;
    function RenderFile(Filename: TBSTR): HRESULT; stdcall;
    function AddSourceFilter(Filename: TBSTR; out Unk: IDispatch): HRESULT; stdcall;
    function get_FilterCollection(out Unk: IDispatch): HRESULT; stdcall;
    function get_RegFilterCollection(out Unk: IDispatch): HRESULT; stdcall;
    function StopWhenReady: HRESULT; stdcall;
  end;

  IMediaEvent = interface(IDispatch)
    ['{56A868B6-0AD4-11CE-B03A-0020AF0BA770}']
    function GetEventHandle(out Event: OAEVENT): HRESULT; stdcall;
    function GetEvent(out EventCode: Longint; out lParam1, lParam2: LONG_PTR; msTimeout: Longint): HRESULT; stdcall;
    function WaitForCompletion(msTimeout: Longint; out EvCode: Longint): HRESULT; stdcall;
    function CancelDefaultHandling(EvCode: Longint): HRESULT; stdcall;
    function RestoreDefaultHandling(EvCode: Longint): HRESULT; stdcall;
    function FreeEventParams(EventCode: Longint; lParam1, lParam2: LONG_PTR): HRESULT; stdcall;
  end;

const
  AM_SEEKING_NoPositioning          = 0;
  AM_SEEKING_AbsolutePositioning    = $1;
  AM_SEEKING_RelativePositioning    = $2;
  AM_SEEKING_IncrementalPositioning = $3;
  AM_SEEKING_PositioningBitsMask    = $3;
  AM_SEEKING_SeekToKeyFrame         = $4;
  AM_SEEKING_ReturnTime             = $8;
  AM_SEEKING_Segment                = $10;
  AM_SEEKING_NoFlush                = $20;

  AM_SEEKING_CanSeekAbsolute        = $1;
  AM_SEEKING_CanSeekForwards        = $2;
  AM_SEEKING_CanSeekBackwards       = $4;
  AM_SEEKING_CanGetCurrentPos       = $8;
  AM_SEEKING_CanGetStopPos          = $10;
  AM_SEEKING_CanGetDuration         = $20;
  AM_SEEKING_CanPlayBackwards       = $40;
  AM_SEEKING_CanDoSegments          = $80;
  AM_SEEKING_Source                 = $100;

type
  IMediaSeeking = interface(IUnknown)
    ['{36B73880-C2C8-11CF-8B46-00805F6CEF60}']
    function GetCapabilities(out Capabilities: DWORD): HRESULT; stdcall;
    function CheckCapabilities(var Capabilities: DWORD): HRESULT; stdcall;
    function IsFormatSupported(var Format: TGUID): HRESULT; stdcall;
    function QueryPreferredFormat(out Format: TGUID): HRESULT; stdcall;
    function GetTimeFormat(out Format: TGUID): HRESULT; stdcall;
    function IsUsingTimeFormat(var Format: TGUID): HRESULT; stdcall;
    function SetTimeFormat(var Format: TGUID): HRESULT; stdcall;
    function GetDuration(out Duration: LONGLONG): HRESULT; stdcall;
    function GetStopPosition(out Stop: LONGLONG): HRESULT; stdcall;
    function GetCurrentPosition(out Current: LONGLONG): HRESULT; stdcall;
    function ConvertTimeFormat(out Target: LONGLONG; pTargetFormat: PGUID; Source: LONGLONG; pSourceFormat: PGUID): HRESULT; stdcall;
    function SetPositions(var Current: LONGLONG; CurrentFlags: DWORD; var Stop: LONGLONG; StopFlags: DWORD): HRESULT; stdcall;
    function GetPositions(out Current, Stop: LONGLONG): HRESULT; stdcall;
    function GetAvailable(out Earliest, Latest: LONGLONG): HRESULT; stdcall;
    function SetRate(Rate: Double): HRESULT; stdcall;
    function GetRate(out Rate: Double): HRESULT; stdcall;
    function GetPreroll(out Preroll: LONGLONG): HRESULT; stdcall;
  end;
                                 

  ISampleGrabberCB = interface(IUnknown)
    ['{0579154A-2B53-4994-B0D0-E773148EFF85}']
    function SampleCB(SampleTime: Double; Sample: IMediaSample): HRESULT; stdcall;
    function BufferCB(SampleTime: Double; pBuffer: PByte; BufferLen: longint): HRESULT; stdcall;
  end;

  ISampleGrabber = interface(IUnknown)
    ['{6B652FFF-11FE-4FCE-92AD-0266B5D7C78F}']
    function SetOneShot(OneShot: BOOL): HRESULT; stdcall;
    function SetMediaType(var Type_: AM_MEDIA_TYPE): HRESULT; stdcall;
    function GetConnectedMediaType(out Type_: AM_MEDIA_TYPE): HRESULT; stdcall;
    function SetBufferSamples(BufferThem: BOOL): HRESULT; stdcall;
    function GetCurrentBuffer(var BufferSize: Longint; pBuffer: Pointer): HRESULT; stdcall;
    function GetCurrentSample(out Sample: IMediaSample): HRESULT; stdcall;
    function SetCallback(Callback: ISampleGrabberCB; WhichMethodToCallback: Longint): HRESULT; stdcall;
  end;
  
  TVMRAspectRatioMode = (
    VMR_ARMODE_NONE,
    VMR_ARMODE_LETTER_BOX
    );

  IVMRAspectRatioControl9 = interface(IUnknown)
    ['{00d96c29-bbde-4efc-9901-bb5036392146}']
    function GetAspectRatioMode(out AspectRatioMode: TVMRAspectRatioMode): HRESULT; stdcall;
    function SetAspectRatioMode(AspectRatioMode: TVMRAspectRatioMode): HRESULT; stdcall;
  end;

  AM_LINE21_CCLEVEL = (AM_L21_CCLEVEL_TC2);

  AM_LINE21_CCSERVICE = (
    AM_L21_CCSERVICE_None,
    AM_L21_CCSERVICE_Caption1,
    AM_L21_CCSERVICE_Caption2,
    AM_L21_CCSERVICE_Text1,
    AM_L21_CCSERVICE_Text2,
    AM_L21_CCSERVICE_XDS
    );
  
  AM_LINE21_DRAWBGMODE = (
    AM_L21_DRAWBGMODE_Opaque,
    AM_L21_DRAWBGMODE_Transparent
    );

  AM_LINE21_CCSTATE = (
    AM_L21_CCSTATE_Off,
    AM_L21_CCSTATE_On
    );

  IAMLine21Decoder = interface(IUnknown)
    ['{6E8D4A21-310C-11D0-B79A-00AA003767A7}']
    function GetDecoderLevel(var Level: AM_LINE21_CCLEVEL): HRESULT; stdcall;
    function GetCurrentService(var Service: AM_LINE21_CCSERVICE): HRESULT; stdcall;
    function SetCurrentService(Service: AM_LINE21_CCSERVICE): HRESULT; stdcall;
    function GetServiceState(var State: AM_LINE21_CCSTATE): HRESULT; stdcall;
    function SetServiceState(State: AM_LINE21_CCSTATE): HRESULT; stdcall;
    // skip methods
  end;

// DVD
const
  IID_IDvdControl2: TGUID = '{33BC7430-EEC0-11D2-8201-00A0C9D74842}';
  IID_IDvdInfo2: TGUID = '{34151510-EEC0-11D2-8201-00A0C9D74842}';

  DVD_CMD_FLAG_None               = $00000000;
  DVD_CMD_FLAG_Flush              = $00000001;
  DVD_CMD_FLAG_SendEvents         = $00000002;
  DVD_CMD_FLAG_Block              = $00000004;
  DVD_CMD_FLAG_StartWhenRendered  = $00000008;
  DVD_CMD_FLAG_EndAfterRendered   = $00000010;

  AM_DVD_HWDEC_PREFER = 1;
  AM_DVD_VMR9_ONLY = $800;

type
  AM_DVD_RENDERSTATUS = record
    hrVPEStatus: HRESULT;
    bDvdVolInvalid: BOOL;
    bDvdVolUnknown: BOOL;
    bNoLine21In: BOOL;
    bNoLine21Out: BOOL;
    iNumStreams: Integer;
    iNumStreamsFailed: Integer;
    dwFailedStreamsFlag: DWORD;
  end;

  //IDvdGraphBuilder = interface(IUnknown)
  //  ['{FCC152B6-F372-11d0-8E00-00C04FD7C08B}']
  //  function GetFiltergraph(out GB: IGraphBuilder): HRESULT; stdcall;
  //  function GetDvdInterface(const riid: TGUID; out IF_): HRESULT; stdcall;
  //  function RenderDvdVideoVolume(PathName: LPCWSTR; Flags: DWORD; out Status: AM_DVD_RENDERSTATUS): HRESULT; stdcall;
  //end;

  DVD_REGISTER = Word;

  TGPRMARRAY = array[0..15] of DVD_REGISTER;
  TSPRMARRAY = array[0..23] of DVD_REGISTER;

  DVD_DOMAIN = (
    DVD_DOMAIN_FirstPlay = 1,
    DVD_DOMAIN_VideoManagerMenu,
    DVD_DOMAIN_VideoTitleSetMenu,
    DVD_DOMAIN_Title,
    DVD_DOMAIN_Stop
  );

  DVD_DISC_SIDE = (
    DVD_SIDE_A = 1,
    DVD_SIDE_B = 2
  );

  DVD_HMSF_TIMECODE = record
    bHours: Byte;
    bMinutes: Byte;
    bSeconds: Byte;
    bFrames: Byte;
  end;

  DVD_PLAYBACK_LOCATION2 = record
    TitleNum: ULONG;
    ChapterNum: ULONG;
    TimeCode: DVD_HMSF_TIMECODE;
    TimeCodeFlags: ULONG;
  end;

  DVD_TextStringType = (
    DVD_Struct_Volume      = $01,
    DVD_Struct_Title       = $02,
    DVD_Struct_ParentalID  = $03,
    DVD_Struct_PartOfTitle = $04,
    DVD_Struct_Cell        = $05,
    DVD_Stream_Audio       = $10,
    DVD_Stream_Subpicture  = $11,
    DVD_Stream_Angle       = $12,
    DVD_Channel_Audio      = $20,
    DVD_General_Name       = $30,
    DVD_General_Comments   = $31,
    DVD_Title_Series       = $38,
    DVD_Title_Movie        = $39,
    DVD_Title_Video        = $3A,
    DVD_Title_Album        = $3B,
    DVD_Title_Song         = $3C,
    DVD_Title_Other        = $3F,
    DVD_Title_Sub_Series   = $40,
    DVD_Title_Sub_Movie    = $41,
    DVD_Title_Sub_Video    = $42,
    DVD_Title_Sub_Album    = $43,
    DVD_Title_Sub_Song     = $44,
    DVD_Title_Sub_Other    = $47,
    DVD_Title_Orig_Series  = $48,
    DVD_Title_Orig_Movie   = $49,
    DVD_Title_Orig_Video   = $4A,
    DVD_Title_Orig_Album   = $4B,
    DVD_Title_Orig_Song    = $4C,
    DVD_Title_Orig_Other   = $4F,
    DVD_Other_Scene        = $50,
    DVD_Other_Cut          = $51,
    DVD_Other_Take         = $52
    );

  DVD_DECODER_CAPS = record
    dwSize: DWORD;
    dwAudioCaps: DWORD;
    dFwdMaxRateVideo: Double;
    dFwdMaxRateAudio: Double;
    dFwdMaxRateSP: Double;
    dBwdMaxRateVideo: Double;
    dBwdMaxRateAudio: Double;
    dBwdMaxRateSP: Double;
    dwRes1: DWORD;
    dwRes2: DWORD;
    dwRes3: DWORD;
    dwRes4: DWORD;
  end;

  TCountryCode = array[0..1] of Byte; // Delphi only

  IDvdState = interface(IUnknown)
    ['{86303d6d-1c4a-4087-ab42-f711167048ef}']
    function GetDiscID(out UniqueID: ULONGLONG): HRESULT; stdcall;
    function GetParentalLevel(out ParentalLevel: ULONG): HRESULT; stdcall;
  end;

  IDvdCmd = interface(IUnknown)
    ['{5A4A97E4-94EE-4A55-9751-74B5643AA27D}']
    function WaitForStart: HRESULT; stdcall;
    function WaitForEnd: HRESULT; stdcall;
  end;

  DVD_TextCharSet = (
    DVD_CharSet_Unicode,
    DVD_CharSet_ISO646,
    DVD_CharSet_JIS_Roman_Kanji,
    DVD_CharSet_ISO8859_1,
    DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana
    );

  DVD_KARAOKE_ASSIGNMENT = (
    DVD_Assignment_reserved0,
    DVD_Assignment_reserved1,
    DVD_Assignment_LR,
    DVD_Assignment_LRM,
    DVD_Assignment_LR1,
    DVD_Assignment_LRM1,
    DVD_Assignment_LR12,
    DVD_Assignment_LRM12
    );

  DVD_VIDEO_COMPRESSION = (
    DVD_VideoCompression_Other,
    DVD_VideoCompression_MPEG1,
    DVD_VideoCompression_MPEG2
    );

  DVD_SUBPICTURE_TYPE = (
    DVD_SPType_NotSpecified,
    DVD_SPType_Language,
    DVD_SPType_Other
    );

  DVD_SUBPICTURE_CODING = (
    DVD_SPCoding_RunLength,
    DVD_SPCoding_Extended,
    DVD_SPCoding_Other
    );

  DVD_MUA_MixingInfo = record
    fMixTo0: BOOL;
    fMixTo1: BOOL;
    fMix0InPhase: BOOL;
    fMix1InPhase: BOOL;
    dwSpeakerPosition: DWORD;
  end;

  DVD_MUA_Coeff = record
    log2_alpha: Double;
    log2_beta: Double;
  end;

  DVD_MultichannelAudioAttributes = record
    Info: array[0..7] of DVD_MUA_MixingInfo;
    Coeff: array[0..7] of DVD_MUA_Coeff;
  end;

  DVD_SUBPICTURE_LANG_EXT = (
    DVD_SP_EXT_NotSpecified              = 0,
    DVD_SP_EXT_Caption_Normal            = 1,
    DVD_SP_EXT_Caption_Big               = 2,
    DVD_SP_EXT_Caption_Children          = 3,
    DVD_SP_EXT_CC_Normal                 = 5,
    DVD_SP_EXT_CC_Big                    = 6,
    DVD_SP_EXT_CC_Children               = 7,
    DVD_SP_EXT_Forced                    = 9,
    DVD_SP_EXT_DirectorComments_Normal   = 13,
    DVD_SP_EXT_DirectorComments_Big      = 14,
    DVD_SP_EXT_DirectorComments_Children = 15
    );

  DVD_AUDIO_LANG_EXT = (
    DVD_AUD_EXT_NotSpecified,
    DVD_AUD_EXT_Captions,
    DVD_AUD_EXT_VisuallyImpaired,
    DVD_AUD_EXT_DirectorComments1,
    DVD_AUD_EXT_DirectorComments2
    );

  DVD_VideoAttributes = record
    fPanscanPermitted: BOOL;
    fLetterboxPermitted: BOOL;
    ulAspectX: ULONG;
    ulAspectY: ULONG;
    ulFrameRate: ULONG;
    ulFrameHeight: ULONG;
    Compression: DVD_VIDEO_COMPRESSION;
    fLine21Field1InGOP: BOOL;
    fLine21Field2InGOP: BOOL;
    ulSourceResolutionX: ULONG;
    ulSourceResolutionY: ULONG;
    fIsSourceLetterboxed: BOOL;
    fIsFilmMode: BOOL;
  end;

  DVD_SubpictureAttributes = record
    Type_: DVD_SUBPICTURE_TYPE;
    CodingMode: DVD_SUBPICTURE_CODING;
    Language: LCID;
    LanguageExtension: DVD_SUBPICTURE_LANG_EXT;
  end;

  DVD_TITLE_APPMODE = (
    DVD_AppMode_Not_Specified = 0,
    DVD_AppMode_Karaoke       = 1,
    DVD_AppMode_Other         = 3
    );

  DVD_AUDIO_APPMODE = (
    DVD_AudioMode_None,
    DVD_AudioMode_Karaoke,
    DVD_AudioMode_Surround,
    DVD_AudioMode_Other
    );

  DVD_AUDIO_FORMAT = (
    DVD_AudioFormat_AC3,
    DVD_AudioFormat_MPEG1,
    DVD_AudioFormat_MPEG1_DRC,
    DVD_AudioFormat_MPEG2,
    DVD_AudioFormat_MPEG2_DRC,
    DVD_AudioFormat_LPCM,
    DVD_AudioFormat_DTS,
    DVD_AudioFormat_SDDS,
    DVD_AudioFormat_Other
    );

  DVD_AudioAttributes = record
    AppMode: DVD_AUDIO_APPMODE;
    //AppModeData: Byte;
    AudioFormat: DVD_AUDIO_FORMAT;
    Language: LCID;
    LanguageExtension: DVD_AUDIO_LANG_EXT;
    fHasMultichannelInfo: BOOL;
    dwFrequency: DWORD;
    bQuantization: Byte;
    bNumberOfChannels: Byte;
    dwReserved: array[0..1] of DWORD;
  end;

  TDVD_TitleAttributes = record
    AppMode: DVD_TITLE_APPMODE;
    // TitleLength: DVD_HMSF_TIMECODE; // union with AppMode
    VideoAttributes: DVD_VideoAttributes;
    ulNumberOfAudioStreams: ULONG ;
    AudioAttributes: array[0..7] of DVD_AudioAttributes;
    MultichannelAudioAttributes: array[0..7] of DVD_MultichannelAudioAttributes;
    ulNumberOfSubpictureStreams: ULONG;
    SubpictureAttributes: array[0..31] of DVD_SubpictureAttributes;
  end;

  DVD_MenuAttributes = record
    fCompatibleRegion: array[0..7] of BOOL;
    VideoAttributes: DVD_VideoAttributes;
    fAudioPresent: BOOL;
    AudioAttributes: DVD_AudioAttributes;
    fSubpicturePresent: BOOL;
    SubpictureAttributes: DVD_SubpictureAttributes;
  end;

  DVD_KaraokeAttributes = record
    bVersion: Byte;
    fMasterOfCeremoniesInGuideVocal1: BOOL;
    fDuet: BOOL;
    ChannelAssignment: DVD_Karaoke_Assignment;
    wChannelContents: array[0..7] of Word;
  end;

  DVD_MENU_ID = (
    DVD_MENU_Title = 2,
    DVD_MENU_Root,
    DVD_MENU_Subpicture,
    DVD_MENU_Audio,
    DVD_MENU_Angle,
    DVD_MENU_Chapter
  );

  DVD_RELATIVE_BUTTON = (
    DVD_Relative_Upper = 1,
    DVD_Relative_Lower,
    DVD_Relative_Left,
    DVD_Relative_Right
  );

  DVD_OPTION_FLAG = (
    DVD_ResetOnStop = 1,
    DVD_NotifyParentalLevelChange,
    DVD_HMSF_TimeCodeEvents,
    DVD_AudioDuringFFwdRew
  );

  IDvdInfo2 = interface(IUnknown)
    ['{34151510-EEC0-11D2-8201-00A0C9D74842}']
    function GetCurrentDomain(out Domain: DVD_DOMAIN): HRESULT; stdcall;
    function GetCurrentLocation(out Location: DVD_PLAYBACK_LOCATION2): HRESULT; stdcall;
    function GetTotalTitleTime(out TotalTime: DVD_HMSF_TIMECODE; out TimeCodeFlags: ULONG): HRESULT; stdcall;
    function GetCurrentButton(out ButtonsAvailable, CurrentButton: ULONG): HRESULT; stdcall;
    function GetCurrentAngle(out AnglesAvailable, CurrentAngle: ULONG): HRESULT; stdcall;
    function GetCurrentAudio(out StreamsAvailable, CurrentStream: ULONG): HRESULT; stdcall;
    function GetCurrentSubpicture(out StreamsAvailable, CurrentStream: ULONG; out IsDisabled: BOOL): HRESULT; stdcall;
    function GetCurrentUOPS(out UOPs: ULONG): HRESULT; stdcall;
    function GetAllSPRMs(out RegisterArray: TSPRMARRAY): HRESULT; stdcall;
    function GetAllGPRMs(out RegisterArray: TGPRMARRAY): HRESULT; stdcall;
    function GetAudioLanguage(Stream: ULONG; out Language: LCID): HRESULT; stdcall;
    function GetSubpictureLanguage(Stream: ULONG; out Language: LCID): HRESULT; stdcall;
    function GetTitleAttributes(ulTitle: ULONG; out Menu: DVD_MenuAttributes; out Title: TDVD_TitleAttributes): HRESULT; stdcall;
    function GetVMGAttributes(out ATR: DVD_MenuAttributes): HRESULT; stdcall;
    function GetCurrentVideoAttributes(out ATR: DVD_VideoAttributes): HRESULT; stdcall;
    function GetAudioAttributes(Stream: ULONG; out ATR: DVD_AudioAttributes): HRESULT; stdcall;
    function GetKaraokeAttributes(Stream: ULONG; out ATR: DVD_KaraokeAttributes): HRESULT; stdcall;
    function GetSubpictureAttributes(Stream :ULONG; out Attributes: DVD_SubpictureAttributes): HRESULT; stdcall;
    function GetDVDVolumeInfo(out NumOfVolumes, Volume: ULONG; out Side: DVD_DISC_SIDE; out NumOfTitles: ULONG): HRESULT; stdcall;
    function GetDVDTextNumberOfLanguages(out NumOfLangs: ULONG): HRESULT; stdcall;
    function GetDVDTextLanguageInfo(LangIndex: ULONG; out NumOfStrings: ULONG; out LangCode: LCID; out CharacterSet: DVD_TextCharSet): HRESULT; stdcall;
    function GetDVDTextStringAsNative(LangIndex, StringIndex: ULONG; Buffer: Pointer; MaxBufferSize: ULONG; out ActualSize: ULONG; out Type_: DVD_TextStringType): HRESULT; stdcall;
    function GetDVDTextStringAsUnicode(LangIndex, StringIndex: ULONG; Buffer: PWChar; MaxBufferSize: ULONG; out ActualSize: ULONG; out Type_: DVD_TextStringType): HRESULT; stdcall;
    function GetPlayerParentalLevel(out ParentalLevel: ULONG; out CountryCode: TCountryCode): HRESULT; stdcall;
    function GetNumberOfChapters(Title: ULONG; out NumOfChapters: ULONG): HRESULT; stdcall;
    function GetTitleParentalLevels(Title: ULONG; out ParentalLevels: ULONG): HRESULT; stdcall;
    function GetDVDDirectory(Path: LPWSTR; MaxSize: ULONG; out ActualSize: ULONG): HRESULT; stdcall;
    function IsAudioStreamEnabled(StreamNum: ULONG; out Enabled: BOOL): HRESULT; stdcall;
    function GetDiscID(Path: LPCWSTR; out DiscID: ULONGLONG): HRESULT; stdcall;
    function GetState(out StateData: IDvdState): HRESULT; stdcall;
    function GetMenuLanguages(out Languages: LCID; MaxLanguages: ULONG; out ActualLanguages: ULONG): HRESULT; stdcall;
    function GetButtonAtPosition(point: TPoint; out ButtonIndex: ULONG): HRESULT; stdcall;
    function GetCmdFromEvent(lParam1: LONG_PTR; out CmdObj: IDvdCmd): HRESULT; stdcall;
    function GetDefaultMenuLanguage(out Language: LCID): HRESULT; stdcall;
    function GetDefaultAudioLanguage(out Language: LCID; out AudioExtension: DVD_AUDIO_LANG_EXT): HRESULT; stdcall;
    function GetDefaultSubpictureLanguage(out Language: LCID; out SubpictureExtension: DVD_SUBPICTURE_LANG_EXT): HRESULT; stdcall;
    function GetDecoderCaps(out Caps: DVD_DECODER_CAPS): HRESULT; stdcall;
    function GetButtonRect(Button: ULONG; out Rect: TRect): HRESULT; stdcall;
    function IsSubpictureStreamEnabled(StreamNum: ULONG; out Enabled: BOOL): HRESULT; stdcall;
  end;
 
  IDvdControl2 = interface(IUnknown)
    ['{33BC7430-EEC0-11D2-8201-00A0C9D74842}']
    function PlayTitle(Title: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayChapterInTitle(Title, Chapter: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayAtTimeInTitle(Title: ULONG; var Time: DVD_HMSF_TIMECODE; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function Stop: HRESULT; stdcall;
    function ReturnFromSubmenu(Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayAtTime(var Time: DVD_HMSF_TIMECODE; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayChapter(Chapter: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayPrevChapter(Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function ReplayChapter(Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayNextChapter(Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayForwards(Speed: Double; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayBackwards(Speed: Double; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function ShowMenu(MenuID: DVD_MENU_ID; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function Resume(Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SelectRelativeButton(buttonDir: DVD_RELATIVE_BUTTON): HRESULT; stdcall;
    function ActivateButton: HRESULT; stdcall;
    function SelectButton(ulButton: ULONG): HResult; stdcall;
    function SelectAndActivateButton(Button: ULONG): HRESULT; stdcall;
    function StillOff: HRESULT; stdcall;
    function Pause(State: BOOL): HRESULT; stdcall;
    function SelectAudioStream(Audio: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SelectSubpictureStream(SubPicture: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SetSubpictureState(State: BOOL; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SelectAngle(Angle: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SelectParentalLevel(ParentalLevel: ULONG): HRESULT; stdcall;
    function SelectParentalCountry(Country: TCountryCode): HRESULT; stdcall;
    function SelectKaraokeAudioPresentationMode(Mode: ULONG): HRESULT; stdcall;
    function SelectVideoModePreference(PreferredDisplayMode: ULONG): HRESULT; stdcall;
    function SetDVDDirectory(Path: LPCWSTR): HRESULT; stdcall;
    function ActivateAtPosition(point: TPoint): HRESULT; stdcall;
    function SelectAtPosition(point: TPoint): HRESULT; stdcall;
    function PlayChaptersAutoStop(Title, Chapter, ChaptersToPlay: ULONG; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function AcceptParentalLevelChange(Accept: BOOL): HRESULT; stdcall;
    function SetOption(flag: DVD_OPTION_FLAG; Enable: BOOL): HRESULT; stdcall;
    function SetState(State: IDvdState; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function PlayPeriodInTitleAutoStop(Title: ULONG; var StartTime, EndTime: DVD_HMSF_TIMECODE; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SetGPRM(Index: ULONG; Value: Word; Flags: DWORD; out Cmd: IDvdCmd): HRESULT; stdcall;
    function SelectDefaultMenuLanguage(Language: LCID): HRESULT; stdcall;
    function SelectDefaultAudioLanguage(Language: LCID; audioExtension: DVD_AUDIO_LANG_EXT): HRESULT; stdcall;
    function SelectDefaultSubpictureLanguage(Language: LCID; subpictureExtension: DVD_SUBPICTURE_LANG_EXT): HRESULT; stdcall;
  end;

implementation
end.
