program mkversion;

uses NTypes, NLib, NStdIO;

var
  version, releasedate, copyright, filever: string;
  now: TTime;
begin
  try
    StdIn.ReadLine(version);
    StdIn.ReadLine(copyright);
    version := Strip(version);
    copyright := Strip(copyright);

    if (Length(Argv) > 1) and (Argv[1] = '-h') then
    begin
      filever := ReplaceChar(version, '.', ',');
      Print('#define PRODUCTVER ' + filever);
      Print('#define PRODUCTVERSTR "' + version + '"');
      Print('#define FILEVER ' + filever);
      Print('#define FILEVERSTR "' + version + '"');
      Print('#define COPYRIGHT "'+ copyright + '\0"');
    end
    else begin
      now := LocalTime(Time);        
      releasedate := Fmt('{0}{1:02}{2:02}', [now.Year, now.Mon, now.MDay]);
      Print('const');
      Print('  Version = ''' + version + ''';');
      Print('  ReleaseDate = ''' + releasedate + ''';');
      Print('  Copyright = ''' + copyright + ''';');
    end;
  except
    on E: EIOError do SysFatal(E);
  end;
end.
