unit NTypes;

interface

type
  TLongintArray = array of Longint;
  TStringArray = array of string;
  TSeekWhence = (swSet, swCur, swEnd);
  TStream = class(TObject)
    function Read(var Buf; NBytes: Cardinal): Cardinal; virtual; abstract;
    function Write(const Buf; NBytes: Cardinal): Cardinal; virtual; abstract;
    function Seek(Offset: Integer; Whence: TSeekWhence=swSet): Cardinal;
        virtual; abstract;
    function Seekable: Boolean; virtual; abstract;
    function Size: Cardinal; virtual; abstract;
  end;
  TFileMode = set of (fmRead, fmWrite, fmReadWrite, fmTruncate);
  TDirMode = set of (dmDirectory, dmReadByOwner, dmWriteByOwner);
  TDir = record
    Name: string;
    Size: Int64;
    ATime: Int64;
    MTime: Int64;
    Mode: TDirMode;
  end;
  TTime = record
    Year: Integer;
    Mon: 1..12;
    MDay: 1..31;
    Hour: 0..23;
    Min: 0..59;
    Sec: 0..61;
    WDay: 0..6;
  end;
  TMChar = array[0..7] of Char;

implementation
end.
