unit NConf;

interface

uses NTypes, NLib;

type
  TConf = class(TObject)
  private
    FFile: TFile;
  public
    Line: string;
    Args: TStringArray;
    constructor Create(const Path: string);
    destructor Destroy; override;
    function ReadLine: Boolean;
    function GetArg(Index: Integer): string;
  end;

implementation

constructor TConf.Create;
begin
  FFile := TFile.Open(Path);
end;

destructor TConf.Destroy;
begin
  FFile.Free;
end;

function TConf.ReadLine;
begin
  while True do
  begin
    Result := FFile.ReadLine(Line);
    if Result then
    begin
      if (Line = '') or (Line[1] in ['#', #13, #10]) then
        Continue;
      if Line[Length(Line)] = #10 then
      begin
        SetLength(Line, Length(Line)-1);
        if Line[Length(Line)] = #13 then
          SetLength(Line, Length(Line)-1);
      end;
    end;
    Args := SplitCommandLine(Line);
    Exit;
  end;
end;

function TConf.GetArg(Index: Integer): string;
begin
  if Index < Length(Args) then
    Result := Args[Index]
  else
    Result := '';
end;

end.
