unit Playlist;

interface

type
  TPlaylist = class(TObject)
  public
    Cur: Integer;
    Count: Integer;
    Items: array of string;
    constructor Create;
    procedure Add(const Path: string);
    procedure AddDir(const Path: string);
    procedure Clear;
    procedure Sort;
  end;

implementation

uses NTypes, NLib;

constructor TPlaylist.Create;
begin
  Clear;
end;

procedure TPlaylist.Add(const Path: string);
begin
  if Count = Length(Items) then 
    SetLength(Items, Count + Count div 4);
  Items[Count] := ReplaceChar(Path, '/', '\');
  Inc(Count);
end;

procedure TPlaylist.AddDir(const Path: string);
var
  i: Integer;
  tmp: array of string;
  dir: TDir;
begin
  SetLength(tmp, 32);
  i := 0;
  with TListDir.Create(Path) do
    try
      while Each(dir) do
        if not (dmDirectory in dir.Mode) then
        begin
          if i = Length(tmp) then
            SetLength(tmp, i + i div 4);
          tmp[i] := JoinPath([Path, dir.Name]);
          Inc(i);
        end;
    finally
      Free;
    end;
  SetLength(tmp, i);
  SortStr(tmp, StrColl);
  for i := 0 to High(tmp) do
    Add(tmp[i]);
end;

procedure TPlaylist.Clear;
begin
  Count := 0;
  SetLength(Items, 32);
end;

procedure TPlaylist.Sort;
begin
  SetLength(Items, Count);
  SortStr(Items, StrColl);
end;

end.
