program NkVp;

uses Windows, Messages, NLib, NForm, MainForm;

{$R *.RES}

function SendPath: Boolean;
var
  wnd: HWnd;
  cd: TCopyDataStruct;
  buf: string;
  i: Integer;
begin
  wnd := FindWindow(PChar(string(TNkVpMainform.ClassName)), nil);
  if wnd = 0 then
  begin
    Result := False;
    Exit;
  end;
  SetForegroundWindow(wnd);
  cd.dwData := 0;
  buf := '';
  for i := 0 to High(Argv) do
    buf := buf + '"' + Argv[i] + '" '; // XXX
  cd.cbData := Length(buf)+1; // +1: null terminator
  cd.lpData := PChar(buf);
  SendMessage(wnd, WM_COPYDATA, 0, LPARAM(@cd));
  Result := True;
end;

var
  i: Integer;
  opt: Char;
  eflag: Boolean = False;
  fflag: Boolean = False;
begin
  App.Name := 'NkVp';
  App.ProfDir := GetEnv('NKTOOLSPROF');
  if App.ProfDir = '' then
    App.ProfDir := DirName(ProgPath)
  else
    App.ProfDir := JoinPath([App.ProfDir, 'nkvp']);

  with TOptParser.Create(Argv) do
    try
      while GetOpt(opt) do
        case opt of
          'e': eflag := True;
          'f': fflag := True;
        else
          App.Error('usage: nkvp [-ef] [file ...]');
          Exit;
        end;
      Argv := Copy(Argv, ArgInd, Length(Argv)-ArgInd+1);
    finally
      Free;
    end;

  if AlreadyRun(App.Name) and (Length(Argv) > 0) then
    if SendPath then
      Exit;

  App.MainForm := TNkVpMainForm.CreateDefaultPos(App.Name, 320, 240);
  with App.MainForm as TNkVpMainForm do
    try
      ExitAtEnd := eflag;
      for i := 0 to High(Argv) do
        if IsDir(Argv[i]) then
          Playlist.AddDir(Argv[i])
        else
          Playlist.Add(Argv[i]);
      Show;
      LoadFromPlaylist(0, True);
      if Player.Loaded and fflag then
        cmFullScreen;
      ExitCode := App.Run;
    finally
      Free;
    end;
end.
