unit InfoDialog;

interface

uses Windows, Messages, ShellAPI, NTypes, NLib, NForm, Player;

type
  TInfoDlg = class(TModelessDlg)
    Icon: HICON;
    Player: TPlayer;
    ATime, MTime: Int64;
    Size: Cardinal;
    procedure UpdateInfo;
    procedure WMDrawItem(var Message: TWMDrawItem); message WM_DRAWITEM;
    procedure WMInitDialog(var Message: TWMInitDialog); message WM_INITDIALOG;
    procedure WMCommand(var Message: TWMCommand); message WM_COMMAND; 
  end;

implementation

{$I dialogid.inc}

function GetIcon(const Path: string): HICON;
var
  id: Word;
  buf: array[0..MAX_PATH] of Char;
begin
  if Length(Path) < SizeOf(buf) then
  begin
    FillChar(buf, SizeOf(buf), 0);
    Move(Path[1], buf, Length(Path));
    id := 1; // if id=1, It is not thumbnail icon but normal file icon
    Result := ExtractAssociatedIcon(HInstance, buf, id);
  end else
    Result := 0;
end;

function BytesFormat(Value: Integer): string;
var
  s: string;
begin
  Result := UnitFormat(Value);
  s := Copy(Result, 1, Length(Result)-1);
  case Result[Length(Result)] of
    'G': Result := s + ' GB';
    'M': Result := s + ' MB';
    'K': Result := s + ' KB';
  else
    Result := Result + ' bytes';
  end;
end;

function NumFormat(Value: Integer): string;
var
  nf: TNumberFmt;
  buf: array[0..255] of Char;
begin
  nf.NumDigits := 0;
  nf.LeadingZero := 0;
  nf.Grouping := 3;
  nf.lpDecimalSep := '.';
  nf.lpThousandSep := ',';
  nf.NegativeOrder := 1;
  GetNumberFormat(0, 0, PChar(IStr(Value)), @nf, buf, SizeOf(buf));
  Result := buf;
end;

procedure TInfoDlg.UpdateInfo;
var
  t: TTime;
begin
  if Player.OpenedDvd then
  begin
    Icon := 0;
    Size := 0;
    Items[IDC_FILENAME].SetText('<DVD>')
  end else
  begin
    Icon := GetIcon(Player.Path);
    Items[IDC_FILENAME].SetText(BaseName(Player.Path));
  end;

  Items[IDC_LOCATION].SetText(DirName(AbsPath(Player.Path)));
  Items[IDC_LENGTH].SetText(Fmt('{0:02}:{1:02}:{2:02}',
      [Player.Len div 3600000, Player.Len mod 3600000 div 60000,
      Player.Len mod 60000 div 1000]));
  Items[IDC_FORMAT].SetText(Player.FormatInfo.Container);
 
  Items[IDC_SIZELABEL].Enable(Player.HasVideo);
  Items[IDC_FPSLABEL].Enable(Player.HasVideo);
  Items[IDC_FILEASPECTLABEL].Enable(Player.HasVideo);
  Items[IDC_VIDEOCODECLABEL].Enable(Player.HasVideo);
  if Player.HasVideo then
  begin
    Items[IDC_SIZE].SetText(Fmt('{0}x{1}', [Player.VideoWidth,
      Player.VideoHeight]));
    Items[IDC_FPS].SetText(Fmt('{0} fps',
      [FStr(Player.FormatInfo.VideoFps, 3)]));
    Items[IDC_FILEASPECT].SetText(FStr(Player.VideoAspect, 4));
    Items[IDC_VIDEOCODEC].SetText(Player.FormatInfo.VideoCodec);
  end else
  begin
    Items[IDC_SIZE].SetText('');
    Items[IDC_FPS].SetText('');
    Items[IDC_FILEASPECT].SetText('');
    Items[IDC_VIDEOCODEC].SetText('');
  end;

  Items[IDC_AUDIOCHANNELS].SetText(IStr(Player.FormatInfo.AudioNumCh));
  Items[IDC_AUDIOSAMPLERATE].SetText(Fmt('{0} Hz',
    [Player.FormatInfo.AudioSampleRate]));
  Items[IDC_AUDIOBITRATE].SetText(Fmt('{0} bps',
    [Player.FormatInfo.AudioBitRate]));
  if Player.FormatInfo.AudioCodec = '' then
    Items[IDC_AUDIOCODEC].SetText('(unknown)')
  else
    Items[IDC_AUDIOCODEC].SetText(Player.FormatInfo.AudioCodec);

  Items[IDC_FILESIZE].SetText(Fmt('{0} ({1} bytes)', [BytesFormat(Size),
    NumFormat(Size)]));
  t := LocalTime(MTime);
  Items[IDC_MODIFIED].SetText(Fmt('{0:04}-{1:02}-{2:02} {3:02}:{4:02}:{5:02}',
      [t.Year, t.Mon, t.MDay, t.Hour, t.Min, t.Sec]));
  t := LocalTime(ATime);
  Items[IDC_ACCESSED].SetText(Fmt('{0:04}-{1:02}-{2:02} {3:02}:{4:02}:{5:02}',
      [t.Year, t.Mon, t.MDay, t.Hour, t.Min, t.Sec]));

  InvalidateRect(Items[IDC_ICON].Handle, nil, False);
end;

procedure TInfoDlg.WMDrawItem(var Message: TWMDrawItem);
begin
  with Message do
    if Ctl = IDC_ICON  then
      with DrawItemStruct^ do
      begin
        FillRect(hDC, rcItem, GetSysColorBrush(COLOR_3DFACE));
        DrawIcon(hDC, 0, 0, Icon);
        Result := 1;
      end;
end;

procedure TInfoDlg.WMInitDialog(var Message: TWMInitDialog);
begin
  UpdateInfo;
  Message.Result := 0;
end;

procedure TInfoDlg.WMCommand(var Message: TWMCommand);
begin
  with Message do
    case ItemID of
      IDOK, IDCANCEL:
        begin
          Result := 1;
          Close;
        end;
    end;
end;

end.

