// interfaces and consts that is not declared in DShow.pas
unit DShow2;

interface

uses Windows, DShow;

const
  IID_ISpecifyPropertyPages: TGUID = '{B196B28B-BAB4-101A-B69C-00AA00341D07}';
  CLSID_SampleGrabber: TGUID = '{C1F400A0-3F08-11D3-9F0B-006008039E37}';
  AM_DVD_HWDEC_PREFER = 1;

type
  IBasicVideo2 = interface(IBasicVideo)
    ['{329bb360-f6ea-11d1-9038-00a0c9697298}']
    function GetPreferredAspectRatio(out plAspectX, plAspectY: Longint):
      HRESULT; stdcall;
  end;

  ISampleGrabberCB = interface(IUnknown)
    ['{0579154A-2B53-4994-B0D0-E773148EFF85}']
    function SampleCB(SampleTime: Double; pSample: IMediaSample): HResult;
      stdcall;
    function BufferCB(SampleTime: Double; pBuffer: PByte; BufferLen: longint):
      HResult; stdcall;
  end;

  ISampleGrabber = interface(IUnknown)
    ['{6B652FFF-11FE-4FCE-92AD-0266B5D7C78F}']
    function SetOneShot(OneShot: BOOL): HResult; stdcall;
    function SetMediaType(var pType: TAM_MEDIA_TYPE): HResult; stdcall;
    function GetConnectedMediaType(out pType: TAM_MEDIA_TYPE): HResult;
      stdcall;
    function SetBufferSamples(BufferThem: BOOL): HResult; stdcall;
    function GetCurrentBuffer(var pBufferSize: longint; pBuffer: Pointer):
      HResult; stdcall;
    function GetCurrentSample(out ppSample: IMediaSample): HResult; stdcall;
    function SetCallback(pCallback: ISampleGrabberCB;
      WhichMethodToCallback: longint): HResult; stdcall;
  end;

// for IDvdInfo2 and IDvdControl2
const
  IID_IDvdControl2: TGUID = '{33BC7430-EEC0-11D2-8201-00A0C9D74842}';
  IID_IDvdInfo2: TGUID = '{34151510-EEC0-11D2-8201-00A0C9D74842}';

  DVD_CMD_FLAG_None               = $00000000;
  DVD_CMD_FLAG_Flush              = $00000001;
  DVD_CMD_FLAG_SendEvents         = $00000002;
  DVD_CMD_FLAG_Block              = $00000004;
  DVD_CMD_FLAG_StartWhenRendered  = $00000008;
  DVD_CMD_FLAG_EndAfterRendered   = $00000010;

type
  PDVD_HMSF_TimeCode = ^TDVD_HMSF_TimeCode;
  TDVD_HMSF_TimeCode = record
    bHours: Byte;
    bMinutes: Byte;
    bSeconds: Byte;
    bFrames: Byte;
  end;

  TDVD_Playback_Location2 = record
    TitleNum: ULONG;
    ChapterNum: ULONG;
    TimeCode: TDVD_HMSF_TimeCode;
    TimeCodeFlags: ULONG;
  end;

  TDVD_TextStringType = (
    DVD_Struct_Volume      = $00000001,
    DVD_Struct_Title       = $00000002,
    DVD_Struct_ParentalID  = $00000003,
    DVD_Struct_PartOfTitle = $00000004,
    DVD_Struct_Cell        = $00000005,
    DVD_Stream_Audio       = $00000010,
    DVD_Stream_Subpicture  = $00000011,
    DVD_Stream_Angle       = $00000012,
    DVD_Channel_Audio      = $00000020,
    DVD_General_Name       = $00000030,
    DVD_General_Comments   = $00000031,
    DVD_Title_Series       = $00000038,
    DVD_Title_Movie        = $00000039,
    DVD_Title_Video        = $0000003A,
    DVD_Title_Album        = $0000003B,
    DVD_Title_Song         = $0000003C,
    DVD_Title_Other        = $0000003F,
    DVD_Title_Sub_Series   = $00000040,
    DVD_Title_Sub_Movie    = $00000041,
    DVD_Title_Sub_Video    = $00000042,
    DVD_Title_Sub_Album    = $00000043,
    DVD_Title_Sub_Song     = $00000044,
    DVD_Title_Sub_Other    = $00000047,
    DVD_Title_Orig_Series  = $00000048,
    DVD_Title_Orig_Movie   = $00000049,
    DVD_Title_Orig_Video   = $0000004A,
    DVD_Title_Orig_Album   = $0000004B,
    DVD_Title_Orig_Song    = $0000004C,
    DVD_Title_Orig_Other   = $0000004F,
    DVD_Other_Scene        = $00000050,
    DVD_Other_Cut          = $00000051,
    DVD_Other_Take         = $00000052
    );

  TDVD_DECODER_CAPS = record
    dwSize           : DWORD;
    dwAudioCaps      : DWORD;
    dFwdMaxRateVideo : double;
    dFwdMaxRateAudio : double;
    dFwdMaxRateSP    : double;
    dBwdMaxRateVideo : double;
    dBwdMaxRateAudio : double;
    dBwdMaxRateSP    : double;
    dwRes1           : DWORD;
    dwRes2           : DWORD;
    dwRes3           : DWORD;
    dwRes4           : DWORD;
  end;
  CountryCode = array[0..1] of BYTE;

  IDvdState = interface(IUnknown)
    ['{86303d6d-1c4a-4087-ab42-f711167048ef}']
    function GetDiscID(out pullUniqueID: Double): HResult; stdcall;
    function GetParentalLevel(out pulParentalLevel: ULONG): HResult; stdcall;
  end;

  IDvdCmd = interface(IUnknown)
    ['{5A4A97E4-94EE-4A55-9751-74B5643AA27D}']
    function WaitForStart: HResult; stdcall;
    function WaitForEnd: HResult; stdcall;
  end;

  TDVD_TextCharSet = (
    DVD_CharSet_Unicode,
    DVD_CharSet_ISO646,
    DVD_CharSet_JIS_Roman_Kanji,
    DVD_CharSet_ISO8859_1,
    DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana
    );

  TDVD_KARAOKE_ASSIGNMENT = (
    DVD_Assignment_reserved0,
    DVD_Assignment_reserved1,
    DVD_Assignment_LR,
    DVD_Assignment_LRM,
    DVD_Assignment_LR1,
    DVD_Assignment_LRM1,
    DVD_Assignment_LR12,
    DVD_Assignment_LRM12
    );

  TDVD_VIDEO_COMPRESSION = (
    DVD_VideoCompression_Other,
    DVD_VideoCompression_MPEG1,
    DVD_VideoCompression_MPEG22
    );

  TDVD_SUBPICTURE_TYPE = (
    DVD_SPType_NotSpecified,
    DVD_SPType_Language,
    DVD_SPType_Other
    );

  TDVD_SUBPICTURE_CODING = (
    DVD_SPCoding_RunLength,
    DVD_SPCoding_Extended,
    DVD_SPCoding_Other
    );

  TDVD_MUA_MixingInfo = record
    fMixTo0           : BOOL;
    fMixTo1           : BOOL;
    fMix0InPhase      : BOOL;
    fMix1InPhase      : BOOL;
    dwSpeakerPosition : DWORD;
  end;

  TDVD_MUA_Coeff = record
    log2_alpha : Double;
    log2_beta  : Double;
  end;

  TDVD_MultichannelAudioAttributes = record
    Info  : array[0..7] of TDVD_MUA_MixingInfo;
    Coeff : array[0..7] of TDVD_MUA_Coeff;
  end;

  TDVD_SUBPICTURE_LANG_EXT = (
    DVD_SP_EXT_NotSpecified              = 0,
    DVD_SP_EXT_Caption_Normal            = 1,
    DVD_SP_EXT_Caption_Big               = 2,
    DVD_SP_EXT_Caption_Children          = 3,
    DVD_SP_EXT_CC_Normal                 = 5,
    DVD_SP_EXT_CC_Big                    = 6,
    DVD_SP_EXT_CC_Children               = 7,
    DVD_SP_EXT_Forced                    = 9,
    DVD_SP_EXT_DirectorComments_Norma    = 13,
    DVD_SP_EXT_DirectorComments_Big      = 14,
    DVD_SP_EXT_DirectorComments_Children = 15
    );

  TDVD_AUDIO_LANG_EXT = (
    DVD_AUD_EXT_NotSpecified,
    DVD_AUD_EXT_Captions,
    DVD_AUD_EXT_VisuallyImpaired,
    DVD_AUD_EXT_DirectorComments1,
    DVD_AUD_EXT_DirectorComments2
    );

  TDVD_VideoAttributes = record
    fPanscanPermitted    : BOOL;
    fLetterboxPermitted  : BOOL;
    ulAspectX            : ULONG;
    ulAspectY            : ULONG;
    ulFrameRate          : ULONG;
    ulFrameHeight        : ULONG;
    Compression          : TDVD_VIDEO_COMPRESSION;
    fLine21Field1InGOP   : BOOL;
    fLine21Field2InGOP   : BOOL;
    ulSourceResolutionX  : ULONG;
    ulSourceResolutionY  : ULONG;
    fIsSourceLetterboxed : BOOL;
    fIsFilmMode          : BOOL;
  end;

  TDVD_SubpictureAttributes = record
    Type_             : TDVD_SUBPICTURE_TYPE ;
    CodingMode        : TDVD_SUBPICTURE_CODING ;
    Language          : LCID ;
    LanguageExtension : TDVD_SUBPICTURE_LANG_EXT ;
  end;

  TDVD_TITLE_APPMODE = (
    DVD_AppMode_Not_Specified = 0,
    DVD_AppMode_Karaoke       = 1,
    DVD_AppMode_Other         = 3
    );

  TDVD_AUDIO_APPMODE = (
    DVD_AudioMode_None,
    DVD_AudioMode_Karaoke,
    DVD_AudioMode_Surround,
    DVD_AudioMode_Other
    );

  TDVD_AUDIO_FORMAT = (
    DVD_AudioFormat_AC3,
    DVD_AudioFormat_MPEG1,
    DVD_AudioFormat_MPEG1_DRC,
    DVD_AudioFormat_MPEG2,
    DVD_AudioFormat_MPEG2_DRC,
    DVD_AudioFormat_LPCM,
    DVD_AudioFormat_DTS,
    DVD_AudioFormat_SDDS,
    DVD_AudioFormat_Other
    );

  TDVD_AudioAttributes = record
    AppMode              : TDVD_AUDIO_APPMODE;
    AppModeData          : BYTE;
    AudioFormat          : TDVD_AUDIO_FORMAT;
    Language             : LCID;
    LanguageExtension    : TDVD_AUDIO_LANG_EXT;
    fHasMultichannelInfo : BOOL;
    dwFrequency          : DWORD;
    bQuantization        : BYTE;
    bNumberOfChannels    : BYTE;
    dwReserved           : array[0..1] of DWORD;
  end;

  TDVD_TitleAttributes = record
    AppMode: TDVD_TITLE_APPMODE;
    VideoAttributes: TDVD_VideoAttributes;
    ulNumberOfAudioStreams: ULONG ;
    AudioAttributes: array[0..7] of TDVD_AudioAttributes;
    MultichannelAudioAttributes: array[0..7] of TDVD_MultichannelAudioAttributes;
    ulNumberOfSubpictureStreams: ULONG ;
    SubpictureAttributes: array[0..31] of TDVD_SubpictureAttributes;
  end;

  TDVD_MenuAttributes = record
    fCompatibleRegion    : array[0..7] of BOOL;
    VideoAttributes      : TDVD_VideoAttributes;
    fAudioPresent        : BOOL;
    AudioAttributes      : TDVD_AudioAttributes;
    fSubpicturePresent   : BOOL;
    SubpictureAttributes : TDVD_SubpictureAttributes;
  end;

  TDVD_KaraokeAttributes = record
    bVersion                         : BYTE;
    fMasterOfCeremoniesInGuideVocal1 : BOOL;
    fDuet                            : BOOL;
    ChannelAssignment                : TDVD_Karaoke_Assignment;
    wChannelContents                 : array[0..7] of WORD;
  end;

  TDVD_MENU_ID = (
    DVD_MENU_Title = 2,
    DVD_MENU_Root,
    DVD_MENU_Subpicture,
    DVD_MENU_Audio,
    DVD_MENU_Angle,
    DVD_MENU_Chapter
  );

  TDVD_RELATIVE_BUTTON = (
    DVD_Relative_Upper = 1,
    DVD_Relative_Lower = 2,
    DVD_Relative_Left  = 3,
    DVD_Relative_Right = 4
  );

  TDVD_OPTION_FLAG = (
    DVD_ResetOnStop = 1,
    DVD_NotifyParentalLevelChange,
    DVD_HMSF_TimeCodeEvents,
    DVD_AudioDuringFFwdRew
  );

  IDvdInfo2 = interface(IUnknown)
    ['{34151510-EEC0-11D2-8201-00A0C9D74842}']
    function GetCurrentDomain(out pDomain: TDVD_Domain): HResult; stdcall;
    function GetCurrentLocation(out pLocation: TDVD_Playback_Location2): HResult; stdcall;
    function GetTotalTitleTime(out pTotalTime: TDVD_HMSF_TimeCode; out ulTimeCodeFlags: ULONG): HResult; stdcall;
    function GetCurrentButton(out pulButtonsAvailable, pulCurrentButton: ULONG): HResult; stdcall;
    function GetCurrentAngle(out pulAnglesAvailable, pulCurrentAngle: ULONG): HResult; stdcall;
    function GetCurrentAudio(out pulStreamsAvailable, pulCurrentStream: ULONG): HResult; stdcall;
    function GetCurrentSubpicture(out pulStreamsAvailable, pulCurrentStream: ULONG; out pbIsDisabled: BOOL): HResult; stdcall;
    function GetCurrentUOPS(out pulUOPs: ULONG): HResult; stdcall;
    function GetAllSPRMs(out pRegisterArray: TSPRMArray): HResult; stdcall;
    function GetAllGPRMs(out pRegisterArray: TGPRMArray): HResult; stdcall;
    function GetAudioLanguage(ulStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetSubpictureLanguage(ulStream: ULONG; out pLanguage: LCID): HResult; stdcall;
    function GetTitleAttributes(ulTitle: ULONG; out pMenu: TDVD_MenuAttributes; out pTitle: TDVD_TitleAttributes): HResult; stdcall;
    function GetVMGAttributes(out pATR: TDVD_MenuAttributes): HResult; stdcall;
    function GetCurrentVideoAttributes(out pATR: TDVD_VideoAttributes): HResult; stdcall;
    function GetAudioAttributes(ulStream: ULONG; out pATR: TDVD_AudioAttributes): HResult; stdcall;
    function GetKaraokeAttributes(ulStream: ULONG; out pAttributes: TDVD_KaraokeAttributes): HResult; stdcall;
    function GetSubpictureAttributes(ulStream :ULONG; out pATR: TDVD_SubpictureAttributes): HResult; stdcall;
    function GetDVDVolumeInfo(out pulNumOfVolumes, pulVolume: ULONG; out pSide: TDVD_Disc_Side; out pulNumOfTitles: ULONG): HResult; stdcall;
    function GetDVDTextNumberOfLanguages(out pulNumOfLangs: ULONG): HResult; stdcall;
    function GetDVDTextLanguageInfo(ulLangIndex: ULONG; out pulNumOfStrings: ULONG; out pLangCode: LCID; out pbCharacterSet: TDVD_TextCharSet): HResult; stdcall;
    function GetDVDTextStringAsNative(ulLangIndex, ulStringIndex: ULONG; out pbBuffer; ulMaxBufferSize: ULONG; out pulActualSize: ULONG; out pType: TDVD_TextStringType): HResult; stdcall;
    function GetDVDTextStringAsUnicode(ulLangIndex, ulStringIndex: ULONG; out pchwBuffer; ulMaxBufferSize: ULONG; out pulActualSize: ULONG; out pType: TDVD_TextStringType): HResult; stdcall;
    function GetPlayerParentalLevel(out pulParentalLevel: ULONG; out pbCountryCode: CountryCode): HResult; stdcall;
    function GetNumberOfChapters(ulTitle: ULONG; out pulNumOfChapters: ULONG): HResult; stdcall;
    function GetTitleParentalLevels(ulTitle: ULONG; out pulParentalLevels: ULONG): HResult; stdcall;
    function GetDVDDirectory(out pszwPath; ulMaxSize: ULONG; out pulActualSize: ULONG): HResult; stdcall;
    function IsAudioStreamEnabled(ulStreamNum: ULONG; out pbEnabled: BOOL): HResult; stdcall;
    function GetDiscID(pszwPath: LPCWSTR; out pullDiscID: Int64): HResult; stdcall;
    function GetState(out pStateData: IDvdState): HResult; stdcall;
    function GetMenuLanguages(out pLanguages: LCID; ulMaxLanguages: ULONG; out pulActualLanguages: ULONG): HResult; stdcall;
    function GetButtonAtPosition(point: Tpoint;out pulButtonIndex: ULONG): HResult; stdcall;
    function GetCmdFromEvent(lParam1: integer; out pCmdObj: IDvdCmd): HResult; stdcall;
    function GetDefaultMenuLanguage(out pLanguage: LCID): HResult; stdcall;
    function GetDefaultAudioLanguage(out pLanguage: LCID; out pAudioExtension: TDVD_Audio_Lang_Ext): HResult; stdcall;
    function GetDefaultSubpictureLanguage(out pLanguage: LCID; out pSubpictureExtension: TDVD_Subpicture_Lang_Ext): HResult; stdcall;
    function GetDecoderCaps(out pCaps: TDVD_Decoder_Caps): HResult; stdcall;
    function GetButtonRect(ulButton: ULONG; out pRect: TRect): HResult; stdcall;
    function IsSubpictureStreamEnabled(ulStreamNum: ULONG; out pbEnabled: BOOL): HResult; stdcall;
  end;
 
  IDvdControl2 = interface(IUnknown)
    ['{33BC7430-EEC0-11D2-8201-00A0C9D74842}']
    function PlayTitle(ulTitle, dwFlags: ULONG; var ppCmd: IDvdCmd): HResult; stdcall;
    function PlayChapterInTitle(ulTitle, ulChapter: ULONG; dwFlags: DWORD; var ppCmd: IDvdCmd): HResult; stdcall;
    function PlayAtTimeInTitle(ulTitle: ULONG; var pStartTime: TDVD_HMSF_TimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function Stop: HResult; stdcall;
    function ReturnFromSubmenu(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayAtTime(pTime: PDVD_HMSF_TimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayChapter(ulChapter: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayPrevChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function ReplayChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayNextChapter(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayForwards(dSpeed: double; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayBackwards(dSpeed: double; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function ShowMenu(MenuID: TDVD_Menu_ID; dwFlags: DWORD;out ppCmd: IDvdCmd): HResult; stdcall;
    function Resume(dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectRelativeButton(buttonDir: TDVD_Relative_Button): HResult; stdcall;
    function ActivateButton: HResult; stdcall;
    function SelectButton(ulButton: ULONG): HResult; stdcall;
    function SelectAndActivateButton(ulButton: ULONG): HResult; stdcall;
    function StillOff: HResult; stdcall;
    function Pause(bState: BOOL): HResult; stdcall;
    function SelectAudioStream(ulAudio: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectSubpictureStream(ulSubPicture: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SetSubpictureState(bState: BOOL; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectAngle(ulAngle: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectParentalLevel(ulParentalLevel: ULONG): HResult; stdcall;
    function SelectParentalCountry(bCountry: CountryCode): HResult; stdcall;
    function SelectKaraokeAudioPresentationMode(ulMode: ULONG): HResult; stdcall;
    function SelectVideoModePreference(ulPreferredDisplayMode: ULONG): HResult; stdcall;
    function SetDVDDirectory(pszwPath: LPCWSTR): HResult; stdcall;
    function ActivateAtPosition(point: TPoint): HResult; stdcall;
    function SelectAtPosition(point : TPoint): HResult; stdcall;
    function PlayChaptersAutoStop(ulTitle, ulChapter, ulChaptersToPlay: ULONG; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function AcceptParentalLevelChange(bAccept: BOOL): HResult; stdcall;
    function SetOption(flag: TDVD_Option_Flag; fState: BOOL): HResult; stdcall;
    function SetState(pState: IDvdState; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function PlayPeriodInTitleAutoStop(ulTitle: ULONG; var pStartTime, pEndTime: TDVD_HMSF_TimeCode; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SetGPRM(ulIndex: ULONG; wValue: WORD; dwFlags: DWORD; out ppCmd: IDvdCmd): HResult; stdcall;
    function SelectDefaultMenuLanguage(Language: LCID): HResult; stdcall;
    function SelectDefaultAudioLanguage(Language: LCID; audioExtension: TDVD_Audio_Lang_Ext): HResult; stdcall;
    function SelectDefaultSubpictureLanguage(Language: LCID; subpictureExtension: TDVD_Subpicture_Lang_Ext): HResult; stdcall;
  end;

implementation
end.
