program NkVp;

uses Windows, Messages, NSys, NLib, NUtil, NForm, MainForm;

{$R *.RES}

function SendPath: Boolean;
var
  wnd: HWnd;
  cd: TCopyDataStruct;
begin
  wnd := FindWindow(PChar(string(TNkVpMainform.ClassName)), nil);
  if wnd = 0 then
  begin
    Result := False;
    Exit;
  end;
  SetForegroundWindow(wnd);
  cd.dwData := 0;
  cd.cbData := Length(Argv[1]);
  cd.lpData := PChar(Argv[1]);
  SendMessage(wnd, WM_COPYDATA, 0, LPARAM(@cd));
  Result := True;
end;

var
  Form: TNkVpMainForm;
  i, j: Integer;
  eflag: Boolean = False;
begin
  AppName := 'NkVp';
  ProfDir := GetEnv('NKTOOLSPROF', '');
  if ProfDir = '' then
    ProfDir := DirName(AbsPath(Argv[0]))
  else
    ProfDir := JoinPath(ProfDir, Lower(AppName));
  About := AppName+' 0.6.3 (2006-07-16)'+EOL+EOL+
    'Copyright (C) 2003-2006 Nobuyuki Honda (Ferdia)'+EOL+EOL+
    'This software is provided under the zlib/libpng license.'+EOL+EOL+
    'Profile Folder: '+ProfDir;

  with TOptParser.Create(Argc, Argv) do
    try
      while GetArg do
        case Flag of
	  'e': eflag := True;
	else
	  ErrMsgBox(AppName, 'usage: nkvp [-e] [file ...]');
	  Exit;
	end;
      j := ArgInd;
    finally
      Free;
    end;

  if AlreadyRun(AppName) and (j < Argc) then
    if SendPath then
      Exit;

  Form := TNkVpMainForm.CreateDefaultPos(AppName, 320, 240);
  try
    SetMainForm(Form);
    Form.ExitAtEnd := eflag;
    for i := j to Argc-1 do
      Form.PlayList.Add(Argv[i]);
    Form.Show;
    Form.LoadFile(0, True);
    ExitCode := MessageLoop;
  finally
    Form.Free;
  end;
end.
