unit NConf;

interface

uses NLib;

type
  TConf = class(TObject)
  private
    FFile: TFile;
  public
    Line: string;
    constructor Create(const Path: string);
    destructor Destroy; override;
    function ReadLine: Boolean;
    function GetToken: string;
  end;

implementation

constructor TConf.Create;
begin
  FFile := TFile.Create(Path, 'r');
end;

destructor TConf.Destroy;
begin
  FFile.Free;
end;

function TConf.ReadLine;
begin
  while True do
  begin
    Result := FFile.ReadLine(Line);
    if Result then
    begin
      if (Line = '') or (Line[1] in ['#', #13, #10]) then
        Continue;
      if Line[Length(Line)] = #10 then
      begin
        SetLength(Line, Length(Line)-1);
        if Line[Length(Line)] = #13 then
          SetLength(Line, Length(Line)-1);
      end;
    end;      
    Exit;
  end;
end;

function TConf.GetToken: string;
var
  ac: Integer;
  av: array[0..0] of string;
begin
  Line := SplitCmd(Line, ac, av);
  Result := av[0];
end;

end.
