unit NCmd;

interface

uses Windows;

const
  IDM_NCMD_FIRST = 20000;

type
  PStringArray = ^StringArray;
  StringArray = array[0..MaxInt div SizeOf(String)-1] of string;

  TCmdList = class(TObject)
  private
    Cmds: PStringArray;
    CmdsCount: Integer;
    Keys: PAccel;
    KeysCount: Integer;
    procedure StrToAccel(var Accel: TAccel; const KeyName, CmdName: string);
  public
    AccelHandle: HAccel;
    constructor Create(const CmdList: array of string);
    destructor Destroy; override;
    procedure BindKeys(const DefaultList, UserList: array of string);
    function GetName(Id: Integer): string;
    function GetId(const CmdName: string): Integer;
  end;

procedure CreateCmdMenu(Handle: HMENU; const CmdList: TCmdList;
  const MenuItemList: array of string);

implementation

uses NKeyMap;

function AccelToKeyName(const Accel: TAccel): string;
var
  ks: TKeyState;
begin
  ks := [];
  if (Accel.fVirt and FALT)     <> 0 then Include(ks, ksAlt);
  if (Accel.fVirt and FSHIFT)   <> 0 then Include(ks, ksShift); 
  if (Accel.fVirt and FCONTROL) <> 0 then Include(ks, ksCtrl); 
  Result := VkeyToStr(ks, Accel.key);
end;
  
procedure CreateCmdMenu(Handle: HMENU; const CmdList: TCmdList;
  const MenuItemList: array of string);
var
  i, j, id: Integer;
  capt, name, keyname: string;
  accel: PAccel;
  menu: HMENU;
begin
  // TODO: support sub menu
  i := 0;
  menu := Handle;
  while i <= High(MenuItemList) do
  begin
    capt := MenuItemList[i];
    name := MenuItemList[i+1];
    if name = '' then
      menu := Handle
    else if name = '-' then
      AppendMenu(menu, MF_SEPARATOR, 0, nil)
    else if name[1] = '>' then 
    begin
      menu := CreatePopupMenu; 
      AppendMenu(Handle, MF_POPUP, menu, PChar(capt));
    end
    else begin
      keyname := '';
      id := CmdList.GetId(name);
      accel := CmdList.Keys;
      for j := 0 to CmdList.KeysCount-1 do
      begin
	if accel.cmd = id then
          if keyname = '' then
	    keyname := AccelToKeyName(accel^)
	  else
	    keyname := keyname + ', ' + AccelToKeyName(accel^);
	Inc(accel);
      end;
      AppendMenu(menu, MF_POPUP, id, PChar(capt+#9+keyname));
    end;
    Inc(i, 2);
  end;
end;

{ TCmdList }

constructor TCmdList.Create(const CmdList: array of string);
begin
  Cmds := @CmdList;
  CmdsCount := High(CmdList)+1;
end;

destructor TCmdList.Destroy;
begin
  if Assigned(Keys) then
    FreeMem(Keys);
  if AccelHandle <> 0 then
    DestroyAcceleratorTable(AccelHandle);
end;

procedure TCmdList.BindKeys(const DefaultList, UserList: array of string);
var
  i, j, n: Integer;
  p: PAccel;
  keylist: array[0..2047] of string;
begin
  n := High(DefaultList);
  for i := 0 to n do
    keylist[i] := DefaultList[i];
  i := 0;
  while (i < High(UserList)) and (UserList[i] <> '') do
  begin
    j := 0;
    while j < n do 
      if UserList[i] = keylist[j] then
      begin
        keylist[j+1] := UserList[i+1];
        Break;
      end else
        Inc(j, 2);
    if j > n then
    begin
      keylist[j] := Userlist[i];
      keylist[j+1] := Userlist[i+1];
      Inc(n, 2);
    end;
    Inc(i, 2);
  end;

  if Assigned(Keys) then
    FreeMem(Keys);
  KeysCount := (n+1) div 2;
  GetMem(Keys, SizeOf(TAccel)*KeysCount);
  p := Keys;
  i := 0;
  while i < KeysCount do
  begin
    StrToAccel(p^, keylist[i*2], keylist[i*2+1]); 
    Inc(i);
    Inc(p);
  end;
  if AccelHandle <> 0 then
    DestroyAcceleratorTable(AccelHandle);
  AccelHandle := CreateAcceleratorTable(Keys^, KeysCount);
end;

procedure TCmdList.StrToAccel(var Accel: TAccel;
  const KeyName, CmdName: string);
var
  ks: TKeyState;
begin
  Accel.cmd := GetId(CmdName);
  StrToVkey(KeyName, ks, Accel.key);
  Accel.fVirt := FVIRTKEY;
  if ksAlt   in ks then Accel.fVirt := Accel.fVirt or FALT;
  if ksCtrl  in ks then Accel.fVirt := Accel.fVirt or FCONTROL;
  if ksShift in ks then Accel.fVirt := Accel.fVirt or FSHIFT;
end;

function TCmdList.GetName(Id: Integer): string;
begin
  Dec(Id, IDM_NCMD_FIRST);
  if Id < CmdsCount then
    Result := Cmds[Id]
  else
    Result := '';
end;

function TCmdList.GetId(const CmdName: string): Integer;
var
  i: Integer;
begin
  for i := 0 to CmdsCount-1 do
    if Cmds[i] = CmdName then
    begin
      Result := IDM_NCMD_FIRST+i;
      Exit;
    end;
  Result := 0;
end;

end.
