unit Command;

interface

const
  cmPause = 'pause';
  cmStop = 'stop';
  cmSeekForward = 'seekforward';
  cmSeekBack = 'seekback';
  cmSeekForwardFast = 'seekforwardfast';
  cmSeekBackFast = 'seekbackfast';
  cmSeekForwardFaster = 'seekforwardfaster';
  cmSeekBackFaster = 'seekbackfaster';
  cmFullScreen = 'fullscreen';
  cmStayOnTop = 'stayontop';
  cmZoom50 = 'zoom50';
  cmZoom100 = 'zoom100';
  cmZoom150 = 'zoom150';
  cmZoom200 = 'zoom200';
  cmZoom300 = 'zoom300';
  cmZoom400 = 'zoom400';
  cmMute = 'mute';
  cmAspect43 = 'aspect43';
  cmAspect169 = 'aspect169';
  cmAspectOrg = 'aspectorg';
  cmAspectAuto = 'aspectauto';
  cmShowSeekBar = 'showseekbar';
  cmAbout = 'about';
  cmExit = 'exit';
  cmFilterMenu = 'filtermenu';
  cmSaveScreenCapture = 'savescreencapture';
  cmSkipPrev = 'skipprev';
  cmSkipNext = 'skipnext';
  cmPlaylist = 'playlist';
  cmRepeat = 'repeat';

  CmdList: array[0..30-1] of string = (
    cmPause,
    cmStop,
    cmSeekForward,
    cmSeekBack,
    cmSeekForwardFast,
    cmSeekBackFast,
    cmSeekForwardFaster,
    cmSeekBackFaster,
    cmFullScreen,
    cmStayOnTop,
    cmZoom50,
    cmZoom100,
    cmZoom150,
    cmZoom200,
    cmZoom300,
    cmZoom400,
    cmMute,
    cmAspect43,
    cmAspect169,
    cmAspectOrg,
    cmAspectAuto,
    cmShowSeekBar,
    cmAbout,
    cmExit,
    cmFilterMenu,
    cmSaveScreenCapture,
    cmSkipPrev,
    cmSkipNext,
    cmPlaylist,
    cmRepeat
  );

  DefaultKeys: array[0..31*2-1] of string = (
    'enter',   cmFullScreen,
    'esc',     cmStop,
    'space',   cmPause,
    'right',   cmSeekForward,
    's-right', cmSeekForwardFast,
    'left',    cmSeekBack,
    's-left',  cmSeekBackFast,
    'down',    cmSeekForwardFaster,
    'up',      cmSeekBackFaster,
    '1',       cmZoom100,
    '2',       cmZoom200,
    '3',       cmZoom300,
    '4',       cmZoom400,
    '5',       cmZoom50,
    'a',       cmAspectAuto,
    'b',       cmSkipPrev,
    'e',       cmAspect43,
    'h',       cmSeekBack,
    'j',       cmSeekForwardFaster,
    'k',       cmSeekBackFaster,
    'l',       cmSeekForward,
    'm',       cmMute,
    'n',       cmSkipNext,
    'o',       cmAspectOrg,
    'p',       cmSkipPrev,
    'q',       cmZoom150,
    'r',       cmRepeat,
    's',       cmShowSeekBar,
    't',       cmStayOnTop,
    'w',       cmAspect169,
    'c-w',     cmExit
  );

  MenuItems: array[0..39*2-1] of string = (
    'Play&list',                  '>',
      '(none)',                   cmPlaylist,
    '',                           '',
    '',                           '-',
    '&Play / Pause',              cmPause,
    '&Stop',                      cmStop,
    'Skip &Previous',             cmSkipPrev,
    'Skip &Next',                 cmSkipNext,
    '&Mute',                      cmMute,
    '&Repeat',                    cmRepeat,
    '',                           '-',
    '&Zoom',                      '>',
      '&50%',                     cmZoom50,
      '&100%',                    cmZoom100,
      '150%(&Q)',                 cmZoom150,
      '&200%',                    cmZoom200,
      '&300%',                    cmZoom300,
      '&400%',                    cmZoom400,
    '',                           '',
    '&Aspect',                    '>',
      'A&uto',                    cmAspectAuto,
      'Ori&ginal',                cmAspectOrg,
      '4:3(&E)',                  cmAspect43,
      '16:9(&W)',                 cmAspect169,
    '',                           '',
    '',                           '-',
    'Full &Screen',               cmFullScreen,
    'Stay &On Top',               cmStayOnTop,
    '&Show Seek Bar',             cmShowSeekBar,
    '-',                          '-',
    'Save Screen &Capture As...', cmSaveScreenCapture,
    '',                           '-',
    '&Filter Properties',         '>',
      '(none)',                   cmFilterMenu,
    '',                           '',
    '',                           '-',
    '&About',                     cmAbout,
    '',                           '-',
    'E&xit',                      cmExit
  );

implementation
end.
