unit ZLibSub;

{$IMPORTEDDATA OFF}

interface

const
  ZLIB_VERSION = '1.2.11';
  Z_OK = 0;
  Z_NO_FLUSH = 0;
  Z_DEFLATED = 8;

type
  alloc_func = function (opaque: Pointer; items: Cardinal; size: Cardinal):
      Pointer; cdecl;
  free_func = procedure (opaque: Pointer; address: Pointer); cdecl;

  z_stream = packed record
    next_in: PChar;
    avail_in: Cardinal;
    total_in: Cardinal;

    next_out: PChar;
    avail_out: Cardinal;
    total_out: Cardinal;

    msg: PChar;
    state: Pointer;

    zalloc: alloc_func;
    zfree: free_func;
    opaque: Pointer;

    data_type: Integer;
    adler: Cardinal;
    reserved: Cardinal;
  end;

function inflate(var strm: z_stream; flush: Integer): Integer;
function inflateEnd(var strm: z_stream): Integer;
function inflateInit2(var strm: z_stream; windowBits: Integer): Integer;

implementation

{$L adler32.obj}
{$L crc32.obj}
{$L infback.obj}
{$L inffast.obj}
{$L inflate.obj}
{$L inftrees.obj}
{$L zutil.obj}

function adler32(adler: Cardinal; const buf: PChar; len: Cardinal): Longint;
  external;
function crc32(crc: Cardinal; const buf: PChar; len: Cardinal): Longint;
  external;
function inflate(var strm: z_stream; flush: Integer): Integer; external;
function inflateEnd(var strm: z_stream): Integer; external;
function inflateInit2_(var strm: z_stream; windowBits: Integer;
    const version: PChar; stream_size: Integer): Integer; external;

function inflateInit2(var strm: z_stream; windowBits: Integer): Integer;
begin
  Result := inflateInit2_(strm, windowBits, ZLIB_VERSION, SizeOf(z_stream));
end;

function _malloc(Size: Integer): Pointer; cdecl;
begin
  GetMem(Result, Size);
end;

procedure _free(Ptr: Pointer); cdecl;
begin
  FreeMem(Ptr);
end;

procedure _memset(B: Pointer; C: Integer; Len: Integer); cdecl;
begin
  FillChar(B^, Len, C);
end;

procedure _memcpy(Dst: Pointer; Src: Pointer; Len: Integer); cdecl;
begin
  Move(Src^, Dst^, Len);
end;

procedure __llmod;
asm
  jmp System.@_llmod;
end;

end.
